/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.ParameterInfoControllerBase;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoContext
implements CreateParameterInfoContext {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final Project myProject;
    private final int myOffset;
    private final int myParameterListStart;
    private final boolean mySingleParameterInfo;
    private PsiElement myHighlightedElement;
    private Object[] myItems;
    private boolean myRequestFocus;

    public ShowParameterInfoContext(Editor editor, Project project, PsiFile file2, int offset, int parameterListStart) {
        this(editor, project, file2, offset, parameterListStart, false);
    }

    public ShowParameterInfoContext(Editor editor, Project project, PsiFile file2, int offset, int parameterListStart, boolean requestFocus) {
        this(editor, project, file2, offset, parameterListStart, requestFocus, false);
    }

    public ShowParameterInfoContext(Editor editor, Project project, PsiFile file2, int offset, int parameterListStart, boolean requestFocus, boolean singleParameterInfo) {
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file2;
        this.myParameterListStart = parameterListStart;
        this.myOffset = offset;
        this.myRequestFocus = requestFocus;
        this.mySingleParameterInfo = singleParameterInfo;
    }

    public Project getProject() {
        return this.myProject;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getParameterListStart() {
        return this.myParameterListStart;
    }

    @NotNull
    public Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            ShowParameterInfoContext.$$$reportNull$$$0(0);
        }
        return editor;
    }

    public PsiElement getHighlightedElement() {
        return this.myHighlightedElement;
    }

    public void setHighlightedElement(PsiElement element2) {
        this.myHighlightedElement = element2;
    }

    public void setItemsToShow(Object[] items) {
        this.myItems = items;
    }

    public Object[] getItemsToShow() {
        return this.myItems;
    }

    public void showHint(PsiElement element2, int offset, ParameterInfoHandler handler2) {
        Object[] itemsToShow = this.getItemsToShow();
        if (itemsToShow == null || itemsToShow.length == 0) {
            return;
        }
        ShowParameterInfoContext.showParameterHint(element2, this.getEditor(), itemsToShow, this.getProject(), itemsToShow.length > 1 ? this.getHighlightedElement() : null, offset, handler2, this.myRequestFocus, this.mySingleParameterInfo);
    }

    private static void showParameterHint(PsiElement element2, Editor editor, Object[] descriptors2, Project project, @Nullable PsiElement highlighted, int elementStart, ParameterInfoHandler<?, ?> handler2, boolean requestFocus, boolean singleParameterInfo) {
        if (editor.isDisposed() || !editor.getComponent().isVisible()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> {
            if (editor.isDisposed() || !element2.isValid() || !ApplicationManager.getApplication().isUnitTestMode() && !EditorActivityManager.getInstance().isVisible(editor)) {
                return;
            }
            Document document = editor.getDocument();
            if (document.getTextLength() < elementStart) {
                return;
            }
            ParameterInfoControllerBase controller = ParameterInfoControllerBase.findControllerAtOffset(editor, elementStart);
            if (controller == null) {
                ParameterInfoControllerBase.createParameterInfoController(project, editor, elementStart, descriptors2, highlighted, element2, handler2, true, requestFocus);
            } else {
                controller.setDescriptors(descriptors2);
                controller.showHint(requestFocus, singleParameterInfo);
            }
        });
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ShowParameterInfoContext", "getEditor"));
    }
}

