/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.accessibility;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public class AccessibilityUsageTrackerCollector
extends CounterUsagesCollector {
    private static final Collection<EventId> ourRaisedEvents = new ConcurrentLinkedQueue<EventId>();
    private static final EventLogGroup GROUP = new EventLogGroup("accessibility", 1);
    public static final EventId SCREEN_READER_DETECTED = GROUP.registerEvent("screen.reader.detected");
    public static final EventId SCREEN_READER_SUPPORT_ENABLED = GROUP.registerEvent("screen.reader.support.enabled");
    public static final EventId SCREEN_READER_SUPPORT_ENABLED_VM = GROUP.registerEvent("screen.reader.support.enabled.in.vmoptions");

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void featureTriggered(EventId feature) {
        ourRaisedEvents.add(feature);
    }

    private static void saveStatistics() {
        ourRaisedEvents.forEach(EventId::log);
    }

    public static class CollectStatisticsTask
    implements StartupActivity.Background {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                CollectStatisticsTask.$$$reportNull$$$0(0);
            }
            AccessibilityUsageTrackerCollector.saveStatistics();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/accessibility/AccessibilityUsageTrackerCollector$CollectStatisticsTask", "runActivity"));
        }
    }
}

