/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.util.PersistentUtil;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\r0\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u00040\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160\u000fH\u0007J$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00180\u000fH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/util/PersistentUtil;", "", "()V", "CORRUPTION_MARKER", "", "LOG_CACHE", "Ljava/io/File;", "corruptionMarkerFile", "getCorruptionMarkerFile$annotations", "getCorruptionMarkerFile", "()Ljava/io/File;", "calcHash", "", "T", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "mapping", "Lkotlin/Function1;", "calcIndexId", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/vcs/log/impl/VcsLogIndexer;", "calcLogId", "Lcom/intellij/vcs/log/VcsLogProvider;", "intellij.platform.vcs.log.impl"})
public final class PersistentUtil {
    @JvmField
    @NotNull
    public static final File LOG_CACHE;
    @NonNls
    private static final String CORRUPTION_MARKER = "corruption.marker";
    public static final PersistentUtil INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getCorruptionMarkerFile$annotations() {
    }

    @NotNull
    public static final File getCorruptionMarkerFile() {
        return new File(LOG_CACHE, CORRUPTION_MARKER);
    }

    @JvmStatic
    @NotNull
    public static final String calcLogId(@NotNull Project project, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        int hashcode2 = INSTANCE.calcHash(logProviders, calcLogId.hashcode.1.INSTANCE);
        return project.getLocationHash() + "." + Integer.toHexString(hashcode2);
    }

    @JvmStatic
    @NotNull
    public static final String calcIndexId(@NotNull Project project, @NotNull Map<VirtualFile, ? extends VcsLogIndexer> logProviders) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        int hashcode2 = INSTANCE.calcHash(logProviders, calcIndexId.hashcode.1.INSTANCE);
        return project.getLocationHash() + "." + Integer.toHexString(hashcode2);
    }

    private final <T> int calcHash(Map<VirtualFile, ? extends T> logProviders, Function1<? super T, String> mapping) {
        Iterable $this$sortedBy$iv = logProviders.keySet();
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List sortedRoots = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                VirtualFile it = (VirtualFile)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (VirtualFile)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getPath();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        return StringUtil.join((Collection)sortedRoots, (Function)((Function)new Function<VirtualFile, String>(mapping, logProviders){
            final /* synthetic */ Function1 $mapping;
            final /* synthetic */ Map $logProviders;

            public final String fun(VirtualFile root) {
                StringBuilder stringBuilder = new StringBuilder();
                VirtualFile virtualFile = root;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"root");
                return stringBuilder.append(virtualFile.getPath()).append(".").append((String)this.$mapping.invoke(MapsKt.getValue((Map)this.$logProviders, (Object)root))).toString();
            }
            {
                this.$mapping = function1;
                this.$logProviders = map2;
            }
        }), (String)".").hashCode();
    }

    private PersistentUtil() {
    }

    static {
        PersistentUtil persistentUtil;
        INSTANCE = persistentUtil = new PersistentUtil();
        LOG_CACHE = new File(PathManager.getSystemPath(), "vcs-log");
    }
}

