/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.BranchStorage;
import com.intellij.dvcs.branch.DvcsBranchInfo;
import com.intellij.dvcs.branch.DvcsBranchUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.BaseState;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="branch-storage")
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0005J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0005J \u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0005R-\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dvcs/branch/BranchStorage;", "Lcom/intellij/openapi/components/BaseState;", "()V", "branches", "", "", "", "Lcom/intellij/dvcs/branch/DvcsBranchInfo;", "getBranches", "()Ljava/util/Map;", "branches$delegate", "Lkotlin/properties/ReadWriteProperty;", "add", "", "typeName", "repository", "Lcom/intellij/dvcs/repo/Repository;", "branchName", "contains", "", "remove", "intellij.platform.vcs.dvcs.impl"})
public final class BranchStorage
extends BaseState {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadWriteProperty branches$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[0]);

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(BranchStorage.class, "branches", "getBranches()Ljava/util/Map;", 0))};
    }

    @Property(surroundWithTag=false)
    @MapAnnotation(keyAttributeName="type")
    @NotNull
    public final Map<String, List<DvcsBranchInfo>> getBranches() {
        return (Map)this.branches$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final boolean contains(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        List<DvcsBranchInfo> list = this.getBranches().get(typeName);
        if (list == null) {
            return false;
        }
        List<DvcsBranchInfo> branches = list;
        return DvcsBranchUtil.find((Collection)branches, repository, branchName) != null;
    }

    public final void add(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        if (this.contains(typeName, repository, branchName)) {
            return;
        }
        this.getBranches().computeIfAbsent(typeName, add.1.INSTANCE).add(new DvcsBranchInfo(DvcsBranchUtil.getPathFor(repository), branchName));
        this.incrementModificationCount();
    }

    public final void remove(@NotNull String typeName, @Nullable Repository repository, @NotNull String branchName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        List<DvcsBranchInfo> list = this.getBranches().get(typeName);
        if (list == null) {
            return;
        }
        List<DvcsBranchInfo> branches = list;
        Object t = DvcsBranchUtil.find((Collection)branches, repository, branchName);
        if (t == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(t, (String)"DvcsBranchUtil.find<Dvcs\u2026ry, branchName) ?: return");
        Object toDelete = t;
        branches.remove(toDelete);
        if (branches.isEmpty()) {
            this.getBranches().remove(typeName);
        }
        this.incrementModificationCount();
    }
}

