/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.rt.execution.testFrameworks.ForkedByModuleSplitter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ForkedSplitter<T>
extends ForkedByModuleSplitter {
    private T myRootDescription;

    public ForkedSplitter(String workingDirsPath, String forkMode, List newArgs) {
        super(workingDirsPath, forkMode, newArgs);
    }

    @Override
    protected int startSplitting(String[] args, String configName, String repeatCount) throws Exception {
        this.myRootDescription = this.createRootDescription(args, configName);
        if (this.myRootDescription == null) {
            return -1;
        }
        if (this.myWorkingDirsPath == null || new File(this.myWorkingDirsPath).length() == 0L) {
            String classpath = System.getProperty("java.class.path");
            String modulePath = System.getProperty("jdk.module.path");
            ArrayList<String> moduleOptions = new ArrayList<String>();
            if (modulePath != null && modulePath.length() > 0) {
                moduleOptions.add("-p");
                moduleOptions.add(modulePath);
            }
            if (repeatCount != null && RepeatCount.getCount(repeatCount) != 0 && this.myForkMode.equals("repeat")) {
                return this.startChildFork(this.createChildArgs(this.myRootDescription), null, classpath, moduleOptions, repeatCount);
            }
            List<T> children = this.getChildren(this.myRootDescription);
            boolean forkTillMethod = this.myForkMode.equalsIgnoreCase("method");
            return this.splitChildren(children, 0, forkTillMethod, null, classpath, moduleOptions, repeatCount);
        }
        return this.splitPerModule(repeatCount);
    }

    @Override
    protected int startPerModuleFork(String moduleName, List<String> classNames, String packageName, String workingDir, String classpath, List<String> moduleOptions, String repeatCount, int result, String filters) throws Exception {
        if (this.myForkMode.equals("none")) {
            List<String> childArgs = this.createPerModuleArgs(packageName, workingDir, classNames, this.myRootDescription, filters);
            return this.startChildFork(childArgs, new File(workingDir), classpath, moduleOptions, repeatCount);
        }
        ArrayList<T> children = new ArrayList<T>(this.getChildren(this.myRootDescription));
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            if (classNames.contains(this.getTestClassName(iterator.next()))) continue;
            iterator.remove();
        }
        boolean forkTillMethod = this.myForkMode.equalsIgnoreCase("method");
        return this.splitChildren(children, result, forkTillMethod, new File(workingDir), classpath, moduleOptions, repeatCount);
    }

    protected int splitChildren(List<T> children, int result, boolean forkTillMethod, File workingDir, String classpath, List<String> moduleOptions, String repeatCount) throws IOException, InterruptedException {
        for (T child : children) {
            List<T> childTests = this.getChildren(child);
            int childResult = childTests.isEmpty() || !forkTillMethod ? this.startChildFork(this.createChildArgs(child), workingDir, classpath, moduleOptions, repeatCount) : this.splitChildren(childTests, result, forkTillMethod, workingDir, classpath, moduleOptions, repeatCount);
            result = Math.min(childResult, result);
        }
        return result;
    }

    protected abstract List<String> createPerModuleArgs(String var1, String var2, List<String> var3, T var4, String var5) throws IOException;

    protected abstract T createRootDescription(String[] var1, String var2) throws Exception;

    protected abstract String getTestClassName(T var1);

    protected abstract List<String> createChildArgs(T var1);

    protected abstract List<T> getChildren(T var1);
}

