/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.OptionsMessageDialog;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfirmationDialog
extends OptionsMessageDialog {
    private final VcsShowConfirmationOption myOption;
    private @NlsContexts.Checkbox String myDoNotShowAgainMessage;
    private final @NlsActions.ActionText String myOkActionName;
    private final @NlsActions.ActionText String myCancelActionName;

    public static boolean requestForConfirmation(@NotNull VcsShowConfirmationOption option, @NotNull Project project, @NotNull @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon) {
        if (option == null) {
            ConfirmationDialog.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ConfirmationDialog.$$$reportNull$$$0(1);
        }
        if (message == null) {
            ConfirmationDialog.$$$reportNull$$$0(2);
        }
        if (title == null) {
            ConfirmationDialog.$$$reportNull$$$0(3);
        }
        return ConfirmationDialog.requestForConfirmation(option, project, message, title, icon, null, null);
    }

    public static boolean requestForConfirmation(@NotNull VcsShowConfirmationOption option, @NotNull Project project, @NotNull @NlsContexts.DialogMessage String message, @NotNull @NlsContexts.DialogTitle String title, @Nullable Icon icon, @Nullable @NlsActions.ActionText String okActionName, @Nullable @NlsActions.ActionText String cancelActionName) {
        if (option == null) {
            ConfirmationDialog.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ConfirmationDialog.$$$reportNull$$$0(5);
        }
        if (message == null) {
            ConfirmationDialog.$$$reportNull$$$0(6);
        }
        if (title == null) {
            ConfirmationDialog.$$$reportNull$$$0(7);
        }
        if (option.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return false;
        }
        ConfirmationDialog dialog = new ConfirmationDialog(project, message, title, icon, option, okActionName, cancelActionName);
        if (!option.isPersistent()) {
            dialog.setDoNotAskOption(null);
        } else {
            dialog.setDoNotShowAgainMessage(UIBundle.message("dialog.options.do.not.ask", new Object[0]));
        }
        return dialog.showAndGet();
    }

    public ConfirmationDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon, VcsShowConfirmationOption option) {
        this(project, message, title, icon, option, null, null);
    }

    public ConfirmationDialog(Project project, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Icon icon, VcsShowConfirmationOption option, @Nullable @NlsContexts.Button String okActionName, @Nullable @NlsContexts.Button String cancelActionName) {
        super(project, message, title, icon);
        this.myOption = option;
        this.myOkActionName = okActionName != null ? okActionName : CommonBundle.getYesButtonText();
        this.myCancelActionName = cancelActionName != null ? cancelActionName : CommonBundle.getNoButtonText();
        this.init();
    }

    public void setDoNotShowAgainMessage(@NlsContexts.Checkbox String doNotShowAgainMessage) {
        this.myDoNotShowAgainMessage = doNotShowAgainMessage;
        this.myCheckBoxDoNotShowDialog.setText(doNotShowAgainMessage);
    }

    @Override
    @NotNull
    protected String getDoNotShowMessage() {
        String string = this.myDoNotShowAgainMessage == null ? super.getDoNotShowMessage() : this.myDoNotShowAgainMessage;
        if (string == null) {
            ConfirmationDialog.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected String getOkActionName() {
        return this.myOkActionName;
    }

    @Override
    protected String getCancelActionName() {
        return this.myCancelActionName;
    }

    @Override
    protected boolean isToBeShown() {
        return this.myOption.getValue() == VcsShowConfirmationOption.Value.SHOW_CONFIRMATION;
    }

    @Override
    protected void setToBeShown(boolean value, boolean onOk) {
        VcsShowConfirmationOption.Value optionValue = value ? VcsShowConfirmationOption.Value.SHOW_CONFIRMATION : (onOk ? VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY : VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY);
        this.myOption.setValue(optionValue);
    }

    @Override
    protected boolean shouldSaveOptionsOnCancel() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ConfirmationDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ConfirmationDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDoNotShowMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "requestForConfirmation";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

