/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.ReadWriteUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UsageInfoToUsageConverter {
    private UsageInfoToUsageConverter() {
    }

    @NotNull
    public static Usage convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo usageInfo) {
        if (descriptor == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(0);
        }
        if (usageInfo == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(1);
        }
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        return UsageInfoToUsageConverter.convert(primaryElements, usageInfo);
    }

    @NotNull
    public static Usage convert(PsiElement @NotNull [] primaryElements, @NotNull UsageInfo usageInfo) {
        ReadWriteAccessDetector.Access rwAccess;
        PsiElement usageElement;
        if (usageInfo == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(2);
        }
        if (primaryElements == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(3);
        }
        if ((usageElement = usageInfo.getElement()) != null && primaryElements.length != 0 && (rwAccess = ReadWriteUtil.getReadWriteAccess((PsiElement[])primaryElements, (PsiElement)usageElement)) != null) {
            return new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, rwAccess != ReadWriteAccessDetector.Access.Write, rwAccess != ReadWriteAccessDetector.Access.Read);
        }
        return new UsageInfo2UsageAdapter(usageInfo);
    }

    public static Usage @NotNull [] convert(@NotNull TargetElementsDescriptor descriptor, UsageInfo @NotNull [] usageInfos) {
        if (descriptor == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(4);
        }
        if (usageInfos == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(5);
        }
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        if (usages == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(6);
        }
        return usages;
    }

    public static Usage @NotNull [] convert(PsiElement @NotNull [] primaryElements, UsageInfo @NotNull [] usageInfos) {
        if (primaryElements == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(7);
        }
        if (usageInfos == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(8);
        }
        Usage[] usageArray = (Usage[])ContainerUtil.map((Object[])usageInfos, info -> UsageInfoToUsageConverter.convert(primaryElements, info), (Object[])new Usage[usageInfos.length]);
        if (usageArray == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(9);
        }
        return usageArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryElements";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/UsageInfoToUsageConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/UsageInfoToUsageConverter";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer<PsiElement>> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer<PsiElement>> myAdditionalSearchedElements;

        public TargetElementsDescriptor(@NotNull PsiElement element) {
            if (element == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(0);
            }
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(@NotNull @NotNull PsiElement @NotNull [] primarySearchedElements) {
            if (primarySearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(1);
            }
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(@NotNull @NotNull PsiElement @NotNull [] primarySearchedElements, @NotNull @NotNull PsiElement @NotNull [] additionalSearchedElements) {
            if (primarySearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(2);
            }
            if (additionalSearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(3);
            }
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        @NotNull
        private static @NotNull PsiElement @NotNull [] convertToPsiElements(@NotNull List<? extends SmartPsiElementPointer<PsiElement>> primary) {
            if (primary == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(4);
            }
            PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.toArray((Collection)ContainerUtil.mapNotNull(primary, SmartPsiElementPointer::getElement), PsiElement.ARRAY_FACTORY);
            if (psiElementArray == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(5);
            }
            return psiElementArray;
        }

        @NotNull
        private static @NotNull List<@NotNull SmartPsiElementPointer<PsiElement>> convertToSmartPointers(@NotNull @NotNull PsiElement @NotNull [] primaryElements) {
            if (primaryElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(6);
            }
            if (primaryElements.length == 0) {
                List<SmartPsiElementPointer<PsiElement>> list = Collections.emptyList();
                if (list == null) {
                    TargetElementsDescriptor.$$$reportNull$$$0(7);
                }
                return list;
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(primaryElements[0].getProject());
            List list = ContainerUtil.mapNotNull((Object[])primaryElements, smartPointerManager::createSmartPsiElementPointer);
            if (list == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public @NotNull PsiElement @NotNull [] getPrimaryElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
        }

        @NotNull
        public @NotNull PsiElement @NotNull [] getAdditionalElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
        }

        @NotNull
        public List<PsiElement> getAllElements() {
            PsiElement element;
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer<PsiElement> pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            for (SmartPsiElementPointer<PsiElement> pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(9);
            }
            return arrayList;
        }

        @NotNull
        public List<SmartPsiElementPointer<PsiElement>> getAllElementPointers() {
            List list = ContainerUtil.concat(this.myPrimarySearchedElements, this.myAdditionalSearchedElements);
            if (list == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(10);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primarySearchedElements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalSearchedElements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primary";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToPsiElements";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToSmartPointers";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllElements";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllElementPointers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToPsiElements";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToSmartPointers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

