/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DynamicEditorActionHandler
extends EditorActionHandler {
    private static final List<EditorActionHandler> UPDATE_MARKER = new ArrayList<EditorActionHandler>();
    private final EditorAction myAction;
    private final EditorActionHandler myBaseHandler;
    private final AtomicReference<List<EditorActionHandler>> myCachedChain;
    private boolean myWorksInInjected;

    DynamicEditorActionHandler(@NotNull EditorAction editorAction, @NotNull EditorActionHandler baseHandler) {
        if (editorAction == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(0);
        }
        if (baseHandler == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(1);
        }
        this.myCachedChain = new AtomicReference();
        this.myAction = editorAction;
        this.myBaseHandler = baseHandler;
    }

    @Override
    public boolean runForAllCarets() {
        return this.getHandler().runForAllCarets();
    }

    @Override
    public boolean isEnabled(Editor editor, DataContext dataContext) {
        return this.getHandler().isEnabled(editor, dataContext);
    }

    @Override
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(3);
        }
        return this.getHandler().isEnabledForCaret(editor, caret, dataContext);
    }

    @Override
    public void execute(@NotNull Editor editor, @Nullable DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(4);
        }
        this.getHandler().execute(editor, dataContext);
    }

    @Override
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(5);
        }
        this.getHandler().doExecute(editor, caret, dataContext);
    }

    @Override
    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(6);
        }
        return this.getHandler().executeInCommand(editor, dataContext);
    }

    @Override
    public DocCommandGroupId getCommandGroupId(@NotNull Editor editor) {
        if (editor == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(7);
        }
        return this.getHandler().getCommandGroupId(editor);
    }

    @Override
    synchronized void setWorksInInjected(boolean worksInInjected) {
        super.setWorksInInjected(worksInInjected);
        this.myWorksInInjected = worksInInjected;
        this.clearCache();
    }

    @Override
    @Nullable
    <T> T getHandlerOfType(@NotNull Class<T> type) {
        if (type == null) {
            DynamicEditorActionHandler.$$$reportNull$$$0(8);
        }
        List<EditorActionHandler> chain = this.getHandlerChain();
        for (int i = chain.size() - 1; i >= 0; --i) {
            T handler = chain.get(i).getHandlerOfType(type);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private EditorActionHandler getHandler() {
        return (EditorActionHandler)ContainerUtil.getLastItem(this.getHandlerChain());
    }

    private synchronized List<EditorActionHandler> getHandlerChain() {
        List<EditorActionHandler> cachedChain = this.myCachedChain.get();
        if (cachedChain != null && cachedChain != UPDATE_MARKER) {
            return cachedChain;
        }
        this.myCachedChain.set(UPDATE_MARKER);
        List<EditorActionHandlerBean> handlerBeans = ActionManagerEx.getInstanceEx().getRegisteredHandlers(this.myAction);
        ArrayList<EditorActionHandler> chain = new ArrayList<EditorActionHandler>(handlerBeans.size());
        chain.add(this.myBaseHandler);
        for (EditorActionHandlerBean handlerBean : handlerBeans) {
            EditorActionHandler handler = handlerBean.getHandler((EditorActionHandler)ContainerUtil.getLastItem(chain));
            if (handler == null) continue;
            handler.setWorksInInjected(this.myWorksInInjected);
            chain.add(handler);
        }
        this.myCachedChain.compareAndSet(UPDATE_MARKER, chain);
        return chain;
    }

    void clearCache() {
        this.myCachedChain.set(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseHandler";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actionSystem/DynamicEditorActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForCaret";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommandGroupId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandlerOfType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

