/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairFunction;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MicrodataUtil {
    public static final Key<List<String>> ITEM_PROP_KEYS = Key.create((String)"microdata.prop");
    public static final String ITEM_REF = "itemref";
    public static final String ITEM_SCOPE = "itemscope";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_PROP = "itemprop";
    public static final String ITEM_ID = "itemid";

    public static boolean hasScopeTag(@Nullable XmlTag tag) {
        return MicrodataUtil.findScopeTag(tag) != null;
    }

    @Nullable
    public static XmlTag findScopeTag(@Nullable XmlTag context) {
        Map<String, XmlTag> id2tag = MicrodataUtil.findScopesWithItemRef(context != null ? context.getContainingFile() : null);
        for (XmlTag tag = context; tag != null; tag = tag.getParentTag()) {
            if (tag != context && tag.getAttribute(ITEM_SCOPE) != null) {
                return tag;
            }
            String id = MicrodataUtil.getStripedAttributeValue(tag, "id");
            if (id == null || !id2tag.containsKey(id)) continue;
            return id2tag.get(id);
        }
        return null;
    }

    private static Map<String, XmlTag> findScopesWithItemRef(final @Nullable PsiFile file) {
        if (!(file instanceof XmlFile)) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<Map<String, XmlTag>>(){

            @NotNull
            public CachedValueProvider.Result<Map<String, XmlTag>> compute() {
                final HashMap result = new HashMap();
                file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        XmlAttribute refAttr = tag.getAttribute(MicrodataUtil.ITEM_REF);
                        if (refAttr != null && tag.getAttribute(MicrodataUtil.ITEM_SCOPE) != null) {
                            MicrodataUtil.getReferencesForAttributeValue(refAttr.getValueElement(), (PairFunction<? super String, ? super Integer, ? extends PsiReference>)((PairFunction)(t, v) -> {
                                result.put(t, tag);
                                return null;
                            }));
                        }
                    }
                });
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create(result, (Object[])new Object[]{file});
                if (result2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/html/impl/util/MicrodataUtil$1", "compute"));
            }
        });
    }

    public static List<String> extractProperties(PsiFile file, String type) {
        List<String> result;
        VirtualFile virtualFile = file.getVirtualFile();
        List<String> list = result = virtualFile != null ? (List<String>)virtualFile.getUserData(ITEM_PROP_KEYS) : null;
        if (virtualFile != null && result == null) {
            result = MicrodataUtil.collectNames(file, type);
            virtualFile.putUserData(ITEM_PROP_KEYS, result);
        }
        return result;
    }

    private static List<String> collectNames(PsiFile file, String type) {
        if (file instanceof XmlFile) {
            CollectNamesVisitor collectNamesVisitor = MicrodataUtil.getVisitorByType(type);
            file.accept((PsiElementVisitor)collectNamesVisitor);
            return collectNamesVisitor.getValues();
        }
        return Collections.emptyList();
    }

    private static CollectNamesVisitor getVisitorByType(String type) {
        if (type.contains("schema.org")) {
            return new CollectNamesFromSchemaOrgVisitor();
        }
        return new CollectNamesByMicrodataVisitor(type);
    }

    public static PsiReference[] getUrlReferencesForAttributeValue(XmlAttributeValue element) {
        return MicrodataUtil.getReferencesForAttributeValue(element, (PairFunction<? super String, ? super Integer, ? extends PsiReference>)((PairFunction)(token, offset) -> {
            if (HtmlUtil.hasHtmlPrefix(token)) {
                TextRange range = TextRange.from((int)offset, (int)token.length());
                URLReference urlReference = new URLReference((PsiElement)element, range, true);
                return new DependentNSReference((PsiElement)element, range, urlReference, true);
            }
            return null;
        }));
    }

    public static PsiReference[] getReferencesForAttributeValue(@Nullable XmlAttributeValue element, PairFunction<? super String, ? super Integer, ? extends PsiReference> refFun) {
        if (element == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text = element.getText();
        String urls = StringUtil.unquoteString((String)text);
        StringTokenizer tokenizer = new StringTokenizer(urls);
        ArrayList<PsiReference> result = new ArrayList<PsiReference>();
        while (tokenizer.hasMoreTokens()) {
            int index;
            String token = tokenizer.nextToken();
            PsiReference ref = (PsiReference)refFun.fun((Object)token, (Object)(index = text.indexOf(token)));
            if (ref == null) continue;
            result.add(ref);
        }
        return result.toArray(PsiReference.EMPTY_ARRAY);
    }

    @Nullable
    public static String getStripedAttributeValue(@Nullable XmlTag tag, String attributeName) {
        String value = tag != null ? tag.getAttributeValue(attributeName) : null;
        return value != null ? StringUtil.unquoteString((String)value) : null;
    }

    public static class CollectNamesFromSchemaOrgVisitor
    extends CollectNamesVisitor {
        public void visitXmlTag(XmlTag tag) {
            String code;
            super.visitXmlTag(tag);
            if ("prop-nam".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag, "class")) && (code = tag.getSubTagText("code")) != null) {
                this.myValues.add(StringUtil.stripHtml((String)code, (boolean)false));
            }
        }
    }

    public static class CollectNamesByMicrodataVisitor
    extends CollectNamesVisitor {
        protected final String myType;
        private boolean myCollecting = false;

        public CollectNamesByMicrodataVisitor(String type) {
            this.myType = type;
        }

        public void visitXmlTag(XmlTag tag) {
            String value = MicrodataUtil.getStripedAttributeValue(tag, MicrodataUtil.ITEM_ID);
            boolean isTypeTag = this.myType.equalsIgnoreCase(value);
            if (isTypeTag) {
                this.myCollecting = true;
            }
            if (this.myCollecting && "name".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag, MicrodataUtil.ITEM_PROP))) {
                this.myValues.add(tag.getValue().getTrimmedText());
            }
            super.visitXmlTag(tag);
            if (isTypeTag) {
                this.myCollecting = false;
            }
        }
    }

    private static class CollectNamesVisitor
    extends XmlRecursiveElementVisitor {
        protected final Set<String> myValues = new HashSet<String>();

        private CollectNamesVisitor() {
        }

        public List<String> getValues() {
            return new ArrayList<String>(this.myValues);
        }
    }
}

