/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.RenameableStateStorageManager;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.configurationStore.StorageVirtualFileTracker;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.messages.MessageBus;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\bJ\u001a\u0010\u0012\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\n0\u0014J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/configurationStore/StorageVirtualFileTracker;", "", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "(Lcom/intellij/util/messages/MessageBus;)V", "filePathToStorage", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "hasDirectoryBasedStorages", "", "vfsListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "addVfsChangesListener", "", "put", "path", "storage", "remove", "processor", "Lkotlin/Function1;", "TrackedStorage", "intellij.platform.configurationStore.impl"})
public final class StorageVirtualFileTracker {
    private final ConcurrentMap<String, TrackedStorage> filePathToStorage;
    private volatile boolean hasDirectoryBasedStorages;
    private final AtomicBoolean vfsListenerAdded;
    private final MessageBus messageBus;

    public final void put(@NotNull String path, @NotNull TrackedStorage storage2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        this.filePathToStorage.put(path, storage2);
        if (storage2 instanceof DirectoryBasedStorage) {
            this.hasDirectoryBasedStorages = true;
        }
        if (this.vfsListenerAdded.compareAndSet(false, true)) {
            this.addVfsChangesListener();
        }
    }

    public final void remove(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.filePathToStorage.remove(path);
    }

    public final void remove(@NotNull Function1<? super TrackedStorage, Boolean> processor2) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Iterator iterator2 = iterator = this.filePathToStorage.values().iterator();
        boolean bl = false;
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            TrackedStorage storage2;
            TrackedStorage trackedStorage = storage2 = (TrackedStorage)iterator3.next();
            Intrinsics.checkNotNullExpressionValue((Object)trackedStorage, (String)"storage");
            if (!((Boolean)processor2.invoke((Object)trackedStorage)).booleanValue()) continue;
            iterator.remove();
        }
    }

    private final void addVfsChangesListener() {
        this.messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(this){
            final /* synthetic */ StorageVirtualFileTracker this$0;

            public void after(@NotNull List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                LinkedHashMap<ComponentManager, V> storageEvents = null;
                for (VFileEvent vFileEvent : events) {
                    ComponentManager componentManager;
                    String path;
                    StateStorage storage2 = null;
                    if (vFileEvent instanceof VFilePropertyChangeEvent && Intrinsics.areEqual((Object)"name", (Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        String oldPath;
                        Intrinsics.checkNotNullExpressionValue((Object)((VFilePropertyChangeEvent)vFileEvent).getOldPath(), (String)"event.oldPath");
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).remove(oldPath);
                        if (storage2 != null) {
                            StateStorageManagerImpl stateStorageManagerImpl;
                            StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).put(((VFilePropertyChangeEvent)vFileEvent).getPath(), storage2);
                            if (storage2 instanceof FileBasedStorage) {
                                ((FileBasedStorage)storage2).setFile(null, Paths.get(((VFilePropertyChangeEvent)vFileEvent).getPath(), new String[0]));
                            }
                            if (!((stateStorageManagerImpl = ((TrackedStorage)storage2).getStorageManager()) instanceof RenameableStateStorageManager)) {
                                stateStorageManagerImpl = null;
                            }
                            RenameableStateStorageManager renameableStateStorageManager = (RenameableStateStorageManager)stateStorageManagerImpl;
                            if (renameableStateStorageManager != null) {
                                Path path2 = Paths.get(((VFilePropertyChangeEvent)vFileEvent).getPath(), new String[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(event.path)");
                                renameableStateStorageManager.pathRenamed(path2, vFileEvent);
                            }
                        }
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)vFileEvent.getPath(), (String)"event.path");
                        storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).get(path);
                        if (storage2 == null && StorageVirtualFileTracker.access$getHasDirectoryBasedStorages$p(this.this$0) && StringsKt.endsWith((String)path, (String)".xml", (boolean)true)) {
                            storage2 = (StateStorage)StorageVirtualFileTracker.access$getFilePathToStorage$p(this.this$0).get(VfsUtil.getParentDir((String)path));
                        }
                    }
                    if (storage2 == null) continue;
                    path = vFileEvent;
                    if (path instanceof VFileMoveEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, Paths.get(((VFileMoveEvent)vFileEvent).getPath(), new String[0]));
                        }
                    } else if (path instanceof VFileCreateEvent) {
                        if (storage2 instanceof FileBasedStorage && !(((VFileCreateEvent)vFileEvent).getRequestor() instanceof SaveSession)) {
                            ((FileBasedStorage)storage2).setFile(((VFileCreateEvent)vFileEvent).getFile(), null);
                        }
                    } else if (path instanceof VFileDeleteEvent) {
                        if (storage2 instanceof FileBasedStorage) {
                            ((FileBasedStorage)storage2).setFile(null, null);
                        } else {
                            ((DirectoryBasedStorage)storage2).setVirtualDir$intellij_platform_configurationStore_impl(null);
                        }
                    } else if (path instanceof VFileCopyEvent) continue;
                    if (!StateStorageManagerKt.isFireStorageFileChangedEvent((VFileEvent)vFileEvent)) continue;
                    Intrinsics.checkNotNull((Object)((TrackedStorage)storage2).getStorageManager().getComponentManager());
                    if (storageEvents == null) {
                        storageEvents = new LinkedHashMap<ComponentManager, V>();
                    }
                    ((LinkedHashSet)storageEvents.computeIfAbsent(componentManager, addVfsChangesListener.after.1.INSTANCE)).add(storage2);
                }
                if (storageEvents != null) {
                    StoreReloadManager.Companion.getInstance().storageFilesChanged((Map)storageEvents);
                }
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    public StorageVirtualFileTracker(@NotNull MessageBus messageBus) {
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        this.messageBus = messageBus;
        this.filePathToStorage = new ConcurrentHashMap();
        this.vfsListenerAdded = new AtomicBoolean();
    }

    public static final /* synthetic */ ConcurrentMap access$getFilePathToStorage$p(StorageVirtualFileTracker $this) {
        return $this.filePathToStorage;
    }

    public static final /* synthetic */ boolean access$getHasDirectoryBasedStorages$p(StorageVirtualFileTracker $this) {
        return $this.hasDirectoryBasedStorages;
    }

    public static final /* synthetic */ void access$setHasDirectoryBasedStorages$p(StorageVirtualFileTracker $this, boolean bl) {
        $this.hasDirectoryBasedStorages = bl;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/configurationStore/StorageVirtualFileTracker$TrackedStorage;", "Lcom/intellij/openapi/components/StateStorage;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "intellij.platform.configurationStore.impl"})
    public static interface TrackedStorage
    extends StateStorage {
        @NotNull
        public StateStorageManagerImpl getStorageManager();

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static boolean isUseVfsForWrite(@NotNull TrackedStorage $this) {
                return StateStorage.DefaultImpls.isUseVfsForWrite((StateStorage)$this);
            }

            @NotNull
            public static StateStorageChooserEx.Resolution getResolution(@NotNull TrackedStorage $this, @NotNull PersistentStateComponent<?> component, @NotNull StateStorageOperation operation) {
                Intrinsics.checkNotNullParameter(component, (String)"component");
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                return StateStorage.DefaultImpls.getResolution((StateStorage)$this, component, (StateStorageOperation)operation);
            }
        }
    }
}

