/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.speller;

import com.intellij.grazie.speller.GrazieSplittingSpeller;
import com.intellij.grazie.speller.Speller;
import com.intellij.grazie.speller.suggestion.filter.SuggestionFilter;
import com.intellij.grazie.speller.utils.UtilsKt;
import com.intellij.grazie.speller.utils.spitter.CamelCaseSplitter;
import com.intellij.grazie.speller.utils.spitter.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grazie/speller/GrazieSplittingSpeller;", "Lcom/intellij/grazie/speller/Speller;", "speller", "config", "Lcom/intellij/grazie/speller/GrazieSplittingSpeller$UserConfig;", "(Lcom/intellij/grazie/speller/Speller;Lcom/intellij/grazie/speller/GrazieSplittingSpeller$UserConfig;)V", "isAlien", "", "word", "", "isMisspelled", "suggestAndRank", "", "", "max", "", "suggestAndScoreForSplitWords", "words", "", "UserConfig", "spellchecker"})
public final class GrazieSplittingSpeller
implements Speller {
    private final Speller speller;
    private final UserConfig config;

    @Override
    public boolean isMisspelled(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        int totalWords = 0;
        boolean isMisspelled = false;
        for (String split : this.config.getSplitter().split(word)) {
            ++totalWords;
            if (isMisspelled) break;
            isMisspelled = isMisspelled || this.speller.isMisspelled(split);
        }
        if (!isMisspelled || totalWords == 1) {
            return isMisspelled;
        }
        return this.speller.isMisspelled(word);
    }

    @Override
    public boolean isAlien(@NotNull String word) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return this.speller.isAlien(word);
    }

    @Override
    @NotNull
    public Map<String, Double> suggestAndRank(@NotNull String word, int max) {
        Map<String, Double> map;
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        if (!this.isMisspelled(word)) {
            return MapsKt.emptyMap();
        }
        List splits = SequencesKt.toList(this.config.getSplitter().split(word));
        if (splits.size() >= this.config.getForceSplittingSize()) {
            map = this.suggestAndScoreForSplitWords(splits, max);
        } else if (splits.size() == 1) {
            Map<String, Double> map2 = this.speller.suggestAndRank(word, max);
            boolean bl = false;
            boolean bl2 = false;
            Map<String, Double> it = map2;
            boolean bl3 = false;
            map = this.config.getFilter().filter(it);
        } else {
            Map<String, Double> map3 = this.speller.suggestAndRank(word, max);
            boolean bl = false;
            boolean bl4 = false;
            Map<String, Double> it = map3;
            boolean bl5 = false;
            Map<String, Double> forWord = this.config.getFilter().filter(it);
            Map<String, Double> forSplits = this.suggestAndScoreForSplitWords(splits, max);
            return UtilsKt.maxOf(forWord, forSplits, suggestAndRank.2.INSTANCE);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Double> suggestAndScoreForSplitWords(Collection<String> words, int max) {
        void $this$mapTo$iv$iv;
        int $i$f$toTypedArray;
        Pair pair;
        boolean $i$f$map;
        Object object;
        int totalMisspelled = 0;
        ArrayList<Pair[]> res = new ArrayList<Pair[]>();
        for (String word : words) {
            if (this.speller.isMisspelled(word)) {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv2;
                Collection $this$map$iv;
                Iterable $this$sortedByDescending$iv;
                int n = totalMisspelled;
                totalMisspelled = n + 1;
                Object object2 = this.speller.suggestAndRank(word, max);
                object = res;
                boolean bl = false;
                boolean bl2 = false;
                Map<String, Double> it22 = object2;
                boolean $i$a$-let-GrazieSplittingSpeller$suggestAndScoreForSplitWords$22 = false;
                Pair[] pairArray = this.config.getFilter().filter(it22);
                object2 = pairArray.entrySet();
                boolean $i$f$sortedByDescending = false;
                void var9_12 = $this$sortedByDescending$iv;
                boolean it22 = false;
                Comparator $i$a$-let-GrazieSplittingSpeller$suggestAndScoreForSplitWords$22 = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Map.Entry it = (Map.Entry)b;
                        boolean bl2 = false;
                        Comparable comparable = Double.valueOf(((Number)it.getValue()).doubleValue());
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Double d = ((Number)it.getValue()).doubleValue();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                    }
                };
                pairArray = CollectionsKt.sortedWith((Iterable)var9_12, (Comparator)$i$a$-let-GrazieSplittingSpeller$suggestAndScoreForSplitWords$22);
                $this$sortedByDescending$iv = (Iterable)pairArray;
                $i$f$map = false;
                var9_12 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    pairArray = destination$iv$iv;
                    boolean bl3 = false;
                    pair = TuplesKt.to(it.getKey(), it.getValue());
                    pairArray.add(pair);
                }
                pairArray = (List)destination$iv$iv;
                $this$map$iv = (Collection)pairArray;
                $i$f$toTypedArray = 0;
                void thisCollection$iv = $this$toTypedArray$iv;
                Pair[] pairArray2 = thisCollection$iv.toArray(new Pair[0]);
                if (pairArray2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                pairArray = pairArray2;
                ((ArrayList)object).add(pairArray);
                continue;
            }
            res.add(new Pair[]{TuplesKt.to((Object)word, (Object)0.0)});
        }
        Pair[] pairArray = new Pair[max];
        int $this$toTypedArray$iv = 0;
        while ($this$toTypedArray$iv < max) {
            $i$f$toTypedArray = $this$toTypedArray$iv;
            int n = $this$toTypedArray$iv++;
            object = pairArray;
            boolean bl = false;
            object[n] = pair = TuplesKt.to((Object)new StringBuilder(), (Object)0.0);
        }
        Pair[] all2 = pairArray;
        int[] counter = new int[res.size()];
        $this$toTypedArray$iv = 0;
        int it = max;
        while ($this$toTypedArray$iv < it) {
            void k;
            int bl = 0;
            int destination$iv$iv = res.size();
            while (bl < destination$iv$iv) {
                void j;
                Pair cur = all2[k];
                Pair add = ((Pair[])res.get((int)j))[counter[j]];
                ((StringBuilder)cur.getFirst()).append((String)add.getFirst());
                all2[k] = TuplesKt.to((Object)cur.getFirst(), (Object)(((Number)cur.getSecond()).doubleValue() + ((Number)add.getSecond()).doubleValue()));
                void v1 = j;
                int n = counter[v1];
                counter[v1] = n + 1;
                if (counter[j] >= ((Object[])res.get((int)j)).length) {
                    counter[j] = 0;
                }
                ++j;
            }
            ++k;
        }
        Pair[] $this$map$iv = all2;
        $i$f$map = false;
        Pair[] j = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        int n = ((void)iterator).length;
        for (int i = 0; i < n; ++i) {
            void it2;
            void item$iv$iv;
            void var16_41 = item$iv$iv = iterator[i];
            object = destination$iv$iv;
            boolean bl = false;
            Pair pair2 = TuplesKt.to((Object)((StringBuilder)it2.getFirst()).toString(), (Object)(((Number)it2.getSecond()).doubleValue() / (double)totalMisspelled));
            object.add(pair2);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    public GrazieSplittingSpeller(@NotNull Speller speller2, @NotNull UserConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)speller2, (String)"speller");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.speller = speller2;
        this.config = config;
    }

    public /* synthetic */ GrazieSplittingSpeller(Speller speller2, UserConfig userConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            userConfig = new UserConfig(null, 0, null, 7, null);
        }
        this(speller2, userConfig);
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word, int max) {
        Intrinsics.checkParameterIsNotNull((Object)word, (String)"word");
        return Speller.DefaultImpls.suggest(this, word, max);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grazie/speller/GrazieSplittingSpeller$UserConfig;", "", "splitter", "Lcom/intellij/grazie/speller/utils/spitter/Splitter;", "forceSplittingSize", "", "filter", "Lcom/intellij/grazie/speller/suggestion/filter/SuggestionFilter;", "(Lcom/intellij/grazie/speller/utils/spitter/Splitter;ILcom/intellij/grazie/speller/suggestion/filter/SuggestionFilter;)V", "getFilter", "()Lcom/intellij/grazie/speller/suggestion/filter/SuggestionFilter;", "getForceSplittingSize", "()I", "getSplitter", "()Lcom/intellij/grazie/speller/utils/spitter/Splitter;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "spellchecker"})
    public static final class UserConfig {
        @NotNull
        private final Splitter splitter;
        private final int forceSplittingSize;
        @NotNull
        private final SuggestionFilter filter;

        @NotNull
        public final Splitter getSplitter() {
            return this.splitter;
        }

        public final int getForceSplittingSize() {
            return this.forceSplittingSize;
        }

        @NotNull
        public final SuggestionFilter getFilter() {
            return this.filter;
        }

        public UserConfig(@NotNull Splitter splitter, int forceSplittingSize, @NotNull SuggestionFilter filter) {
            Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
            Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
            this.splitter = splitter;
            this.forceSplittingSize = forceSplittingSize;
            this.filter = filter;
        }

        public /* synthetic */ UserConfig(Splitter splitter, int n, SuggestionFilter suggestionFilter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                splitter = CamelCaseSplitter.INSTANCE;
            }
            if ((n2 & 2) != 0) {
                n = 3;
            }
            if ((n2 & 4) != 0) {
                suggestionFilter = SuggestionFilter.None.INSTANCE;
            }
            this(splitter, n, suggestionFilter);
        }

        public UserConfig() {
            this(null, 0, null, 7, null);
        }

        @NotNull
        public final Splitter component1() {
            return this.splitter;
        }

        public final int component2() {
            return this.forceSplittingSize;
        }

        @NotNull
        public final SuggestionFilter component3() {
            return this.filter;
        }

        @NotNull
        public final UserConfig copy(@NotNull Splitter splitter, int forceSplittingSize, @NotNull SuggestionFilter filter) {
            Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
            Intrinsics.checkParameterIsNotNull((Object)filter, (String)"filter");
            return new UserConfig(splitter, forceSplittingSize, filter);
        }

        public static /* synthetic */ UserConfig copy$default(UserConfig userConfig, Splitter splitter, int n, SuggestionFilter suggestionFilter, int n2, Object object) {
            if ((n2 & 1) != 0) {
                splitter = userConfig.splitter;
            }
            if ((n2 & 2) != 0) {
                n = userConfig.forceSplittingSize;
            }
            if ((n2 & 4) != 0) {
                suggestionFilter = userConfig.filter;
            }
            return userConfig.copy(splitter, n, suggestionFilter);
        }

        @NotNull
        public String toString() {
            return "UserConfig(splitter=" + this.splitter + ", forceSplittingSize=" + this.forceSplittingSize + ", filter=" + this.filter + ")";
        }

        public int hashCode() {
            Splitter splitter = this.splitter;
            SuggestionFilter suggestionFilter = this.filter;
            return ((splitter != null ? splitter.hashCode() : 0) * 31 + Integer.hashCode(this.forceSplittingSize)) * 31 + (suggestionFilter != null ? suggestionFilter.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UserConfig)) break block3;
                    UserConfig userConfig = (UserConfig)object;
                    if (!Intrinsics.areEqual((Object)this.splitter, (Object)userConfig.splitter) || this.forceSplittingSize != userConfig.forceSplittingSize || !Intrinsics.areEqual((Object)this.filter, (Object)userConfig.filter)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

