/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 3ul) => u64vec3(2ul, 1ul, 1ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 1192ul) => u64vec3(395ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 1048576ul) => u64vec3(349451ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 4251475ul) => u64vec3(2596034ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 29852643761ul) => u64vec3(16899399912ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 4398046511104ul) => u64vec3(3960841000203ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 3948976685146ul) => u64vec3(845360637819ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 135763469567146206ul) => u64vec3(111462107229017405ul, 85ul, 94ul)
 * (u64vec3(1333333333333333259ul, 85ul, 94ul) % 11654173250180970009ul) => u64vec3(1333333333333333259ul, 85ul, 94ul)
 * (u64vec3(167ul, 66ul, 187ul) % 3ul) => u64vec3(2ul, 0ul, 1ul)
 * (u64vec3(167ul, 66ul, 187ul) % 1192ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) % 1048576ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) % 4251475ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) % 29852643761ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) % 4398046511104ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) % 3948976685146ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) % 135763469567146206ul) => u64vec3(167ul, 66ul, 187ul)
 * (u64vec3(167ul, 66ul, 187ul) % 11654173250180970009ul) => u64vec3(167ul, 66ul, 187ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 3ul), u64vec3(2ul, 1ul, 1ul))) ? 1 : -1] array0;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 1192ul), u64vec3(395ul, 85ul, 94ul))) ? 1 : -1] array1;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 1048576ul), u64vec3(349451ul, 85ul, 94ul))) ? 1 : -1] array2;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 4251475ul), u64vec3(2596034ul, 85ul, 94ul))) ? 1 : -1] array3;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 29852643761ul), u64vec3(16899399912ul, 85ul, 94ul))) ? 1 : -1] array4;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 4398046511104ul), u64vec3(3960841000203ul, 85ul, 94ul))) ? 1 : -1] array5;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 3948976685146ul), u64vec3(845360637819ul, 85ul, 94ul))) ? 1 : -1] array6;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 135763469567146206ul), u64vec3(111462107229017405ul, 85ul, 94ul))) ? 1 : -1] array7;
  float[all(equal((u64vec3(1333333333333333259ul, 85ul, 94ul) % 11654173250180970009ul), u64vec3(1333333333333333259ul, 85ul, 94ul))) ? 1 : -1] array8;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 3ul), u64vec3(2ul, 0ul, 1ul))) ? 1 : -1] array9;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 1192ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array10;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 1048576ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array11;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 4251475ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array12;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 29852643761ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array13;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 4398046511104ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array14;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 3948976685146ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array15;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 135763469567146206ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array16;
  float[all(equal((u64vec3(167ul, 66ul, 187ul) % 11654173250180970009ul), u64vec3(167ul, 66ul, 187ul))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
