"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var get_legend_size_1 = require("../../../../state/selectors/get_legend_size");
var commons_1 = require("../../../../utils/commons");
var dimensions_1 = require("../../utils/dimensions");
var compute_axis_ticks_dimensions_1 = require("./compute_axis_ticks_dimensions");
var get_axis_styles_1 = require("./get_axis_styles");
var get_specs_1 = require("./get_specs");
exports.computeChartDimensionsSelector = re_reselect_1.default([
    get_chart_container_dimensions_1.getChartContainerDimensionsSelector,
    get_chart_theme_1.getChartThemeSelector,
    compute_axis_ticks_dimensions_1.computeAxisTicksDimensionsSelector,
    get_specs_1.getAxisSpecsSelector,
    get_axis_styles_1.getAxesStylesSelector,
    get_legend_size_1.getLegendSizeSelector,
], function (chartContainerDimensions, chartTheme, axesTicksDimensions, axesSpecs, axesStyles, legendSize) {
    return dimensions_1.computeChartDimensions(chartContainerDimensions, chartTheme, axesTicksDimensions, axesStyles, axesSpecs, getLegendDimension(legendSize));
})(get_chart_id_1.getChartIdSelector);
function getLegendDimension(_a) {
    var position = _a.position, width = _a.width, height = _a.height, margin = _a.margin;
    var left = 0;
    var top = 0;
    if (position === commons_1.Position.Left) {
        left = width + margin * 2;
    }
    else if (position === commons_1.Position.Top) {
        top = height + margin * 2;
    }
    return {
        left: left,
        top: top,
    };
}
//# sourceMappingURL=compute_chart_dimensions.js.map