/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.expr.Keyword;
import gnu.lists.ImmutablePair;
import gnu.lists.LList;
import gnu.mapping.ArgList;
import gnu.mapping.ArgListImpl;
import gnu.mapping.ArgListVector;
import gnu.mapping.CallContext;
import java.util.RandomAccess;

public class ArgListPair
extends ImmutablePair
implements ArgList,
RandomAccess {
    private ArgListVector arguments;
    private int start;

    protected ArgListPair(ArgListVector base2, int skip) {
        super(base2.get(skip), null);
        this.arguments = base2;
        this.start = skip;
    }

    public static LList getArgs(CallContext ctx) {
        return ArgListPair.valueOf(ArgListVector.getArgs(ctx));
    }

    public static LList valueOf(ArgListVector args) {
        return args == null || args.isEmpty() ? LList.Empty : new ArgListPair(args, 0);
    }

    public static LList valueOf(ArgListVector args, int skip) {
        return args == null || args.size() <= skip ? LList.Empty : new ArgListPair(args, skip);
    }

    @Override
    public Object getArgAsObject(int i) {
        if (i < this.firstKeyword()) {
            return this.get(i);
        }
        if (i >= this.firstKeyword() + this.numKeywords()) {
            return this.get(i + this.numKeywords());
        }
        return this.get(2 * i - this.firstKeyword() + 1);
    }

    @Override
    public String getKeyword(int i) {
        int firstKeyword = this.firstKeyword();
        if (i < firstKeyword || i >= firstKeyword + this.numKeywords()) {
            return null;
        }
        return ((Keyword)this.get(2 * i - firstKeyword)).getName();
    }

    @Override
    public int findKeyword(String key) {
        return ArgListImpl.findKeyword(this, key);
    }

    @Override
    public int numArguments() {
        return this.arguments.size() - this.start - this.numKeywords();
    }

    @Override
    public int numKeywords() {
        int numKeywordsBase = this.arguments.numKeywords();
        int firstKeywordBase = this.arguments.firstKeyword();
        if (this.start <= firstKeywordBase) {
            return numKeywordsBase;
        }
        if (this.start >= firstKeywordBase + 2 * numKeywordsBase) {
            return 0;
        }
        return firstKeywordBase - (this.start + 1 >> 1);
    }

    @Override
    public int firstKeyword() {
        int numKeywordsBase = this.arguments.numKeywords();
        int firstKeywordBase = this.arguments.firstKeyword();
        if (this.start <= firstKeywordBase) {
            return firstKeywordBase;
        }
        if (this.start >= firstKeywordBase + 2 * numKeywordsBase) {
            return 0;
        }
        return this.start & 1;
    }

    @Override
    public int size() {
        return this.arguments.size() - this.start;
    }

    @Override
    public Object get(int index) {
        return this.arguments.get(this.start + index);
    }

    @Override
    public Object getCdr() {
        if (this.cdr == null) {
            this.cdr = ArgListPair.valueOf(this.arguments, this.start + 1);
        }
        return this.cdr;
    }
}

