/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class TemplatedTMSTileSource
extends TMSTileSource
implements TemplatedTileSource {
    private Random rand;
    private String[] randomParts;
    private final Map<String, String> headers = new HashMap<String, String>();
    private boolean inverse_zoom = false;
    private int zoom_offset = 0;
    private static final String COOKIE_HEADER = "Cookie";
    private static final Pattern PATTERN_ZOOM = Pattern.compile("\\{(?:(\\d+)-)?z(?:oom)?([+-]\\d+)?\\}");
    private static final Pattern PATTERN_X = Pattern.compile("\\{x\\}");
    private static final Pattern PATTERN_Y = Pattern.compile("\\{y\\}");
    private static final Pattern PATTERN_Y_YAHOO = Pattern.compile("\\{!y\\}");
    private static final Pattern PATTERN_NEG_Y = Pattern.compile("\\{-y\\}");
    private static final Pattern PATTERN_SWITCH = Pattern.compile("\\{switch:([^}]+)\\}");
    private static final Pattern PATTERN_HEADER = Pattern.compile("\\{header\\(([^,]+),([^}]+)\\)\\}");
    private static final Pattern PATTERN_PARAM = Pattern.compile("\\{((?:\\d+-)?z(?:oom)?(:?[+-]\\d+)?|x|y|!y|-y|switch:([^}]+))\\}");
    private static final Pattern[] ALL_PATTERNS = new Pattern[]{PATTERN_HEADER, PATTERN_ZOOM, PATTERN_X, PATTERN_Y, PATTERN_Y_YAHOO, PATTERN_NEG_Y, PATTERN_SWITCH};

    public TemplatedTMSTileSource(TileSourceInfo info) {
        super(info);
        String cookies = info.getCookies();
        if (cookies != null && !cookies.isEmpty()) {
            this.headers.put(COOKIE_HEADER, cookies);
        }
        this.handleTemplate();
    }

    private void handleTemplate() {
        Matcher m = PATTERN_SWITCH.matcher(this.baseUrl);
        if (m.find()) {
            this.rand = new Random();
            this.randomParts = m.group(1).split(",");
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = PATTERN_HEADER.matcher(this.baseUrl);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(output, "");
        }
        matcher.appendTail(output);
        this.baseUrl = output.toString();
        m = PATTERN_ZOOM.matcher(this.baseUrl);
        if (m.find()) {
            if (m.group(1) != null) {
                this.inverse_zoom = true;
                this.zoom_offset = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null) {
                String ofs = m.group(2);
                if (ofs.startsWith("+")) {
                    ofs = ofs.substring(1);
                }
                this.zoom_offset += Integer.parseInt(ofs);
            }
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        StringBuffer url = new StringBuffer(this.baseUrl.length());
        Matcher matcher = PATTERN_PARAM.matcher(this.baseUrl);
        while (matcher.find()) {
            String replacement = "replace";
            switch (matcher.group(1)) {
                case "z": 
                case "zoom": {
                    replacement = Integer.toString((this.inverse_zoom ? -1 * zoom : zoom) + this.zoom_offset);
                    break;
                }
                case "x": {
                    replacement = Integer.toString(tilex);
                    break;
                }
                case "y": {
                    replacement = Integer.toString(tiley);
                    break;
                }
                case "!y": {
                    replacement = Integer.toString((int)Math.pow(2.0, zoom - 1) - 1 - tiley);
                    break;
                }
                case "-y": {
                    replacement = Integer.toString((int)Math.pow(2.0, zoom) - 1 - tiley);
                    break;
                }
                case "switch:": {
                    replacement = this.randomParts[this.rand.nextInt(this.randomParts.length)];
                    break;
                }
                default: {
                    replacement = PATTERN_ZOOM.matcher("{" + matcher.group(1) + "}").matches() ? Integer.toString((this.inverse_zoom ? -1 * zoom : zoom) + this.zoom_offset) : (PATTERN_SWITCH.matcher("{" + matcher.group(1) + "}").matches() ? this.randomParts[this.rand.nextInt(this.randomParts.length)] : '{' + matcher.group(1) + '}');
                }
            }
            matcher.appendReplacement(url, replacement);
        }
        matcher.appendTail(url);
        return url.toString().replace(" ", "%20");
    }

    public static void checkUrl(String url) {
        assert (url != null && !"".equals(url)) : "URL cannot be null or empty";
        Matcher m = Pattern.compile("\\{[^}]*\\}").matcher(url);
        while (m.find()) {
            boolean isSupportedPattern = false;
            for (Pattern pattern : ALL_PATTERNS) {
                if (!pattern.matcher(m.group()).matches()) continue;
                isSupportedPattern = true;
                break;
            }
            if (isSupportedPattern) continue;
            throw new IllegalArgumentException(m.group() + " is not a valid TMS argument. Please check this server URL:\n" + url);
        }
    }
}

