/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.reseed;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.util.VersionComparator;

public class ReseedBundler {
    private final RouterContext _context;
    private static final String ROUTERINFO_PREFIX = "routerInfo-";
    private static final String ROUTERINFO_SUFFIX = ".dat";
    private static final int MINIMUM = 50;
    private static final String MIN_VERSION = "0.9.36";

    public ReseedBundler(RouterContext ctx) {
        this._context = ctx;
    }

    public File createZip(int count) throws IOException {
        String name;
        Hash me = this._context.routerHash();
        boolean routerCount = false;
        int copied = 0;
        long tooOld = System.currentTimeMillis() - 604800000L;
        ArrayList<RouterInfo> infos = new ArrayList<RouterInfo>(this._context.netDb().getRouters());
        HashMap<String, Object> ipMap = new HashMap<String, Object>(count);
        ArrayList<RouterInfo> toWrite = new ArrayList<RouterInfo>(count);
        Collections.shuffle(infos);
        for (RouterInfo ri : infos) {
            Collection<RouterAddress> addrs;
            if (copied >= count) break;
            Hash key = ri.getIdentity().calculateHash();
            if (key.equals(me) || ri.getPublished() < tooOld || ri.getCapabilities().contains("U") || ri.getCapabilities().contains("K") || VersionComparator.comp(ri.getVersion(), MIN_VERSION) < 0 || (addrs = ri.getAddresses()).isEmpty()) continue;
            name = ReseedBundler.getRouterInfoName(key);
            boolean hasIntro = false;
            boolean hasIPv4 = false;
            boolean dupIP = false;
            for (RouterAddress addr : addrs) {
                if ("SSU".equals(addr.getTransportStyle()) && addr.getOption("ihost0") != null) {
                    hasIntro = true;
                    break;
                }
                String host = addr.getHost();
                if (host == null || !host.contains(".")) continue;
                hasIPv4 = true;
                Hash old = (Hash)ipMap.put(host, key);
                if (old == null || old.equals(key)) continue;
                dupIP = true;
                break;
            }
            if (dupIP || hasIntro || !hasIPv4 || this._context.commSystem().isInStrictCountry(ri)) continue;
            toWrite.add(ri);
            ++copied;
        }
        if (toWrite.isEmpty()) {
            throw new IOException("No router infos to include. Reseed yourself first.");
        }
        if (toWrite.size() < Math.min(count, 50)) {
            throw new IOException("Not enough router infos to include, wanted " + count + " but only found " + toWrite.size() + ". Please try again later.");
        }
        File rv = new File(this._context.getTempDir(), "genreseed-" + this._context.random().nextInt() + ".zip");
        ZipOutputStream zip = null;
        try {
            zip = new ZipOutputStream(new FileOutputStream(rv));
            for (RouterInfo ri : toWrite) {
                name = ReseedBundler.getRouterInfoName(ri.getIdentity().calculateHash());
                ZipEntry entry = new ZipEntry(name);
                entry.setTime(ri.getPublished());
                zip.putNextEntry(entry);
                ri.writeBytes(zip);
                zip.closeEntry();
            }
        }
        catch (DataFormatException dfe) {
            rv.delete();
            IOException ioe = new IOException(dfe.getMessage());
            ioe.initCause(dfe);
            throw ioe;
        }
        catch (IOException ioe) {
            rv.delete();
            throw ioe;
        }
        finally {
            if (zip != null) {
                try {
                    zip.finish();
                    zip.close();
                }
                catch (IOException ioe) {
                    rv.delete();
                    throw ioe;
                }
            }
        }
        return rv;
    }

    private static String getRouterInfoName(Hash hash) {
        String b64 = hash.toBase64();
        return ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX;
    }
}

