/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.report.unbound.UnboundRuleInput;
import org.gradle.util.CollectionUtils;

@ThreadSafe
class UnboundRulesProcessor {
    private final Iterable<? extends RuleBinder> binders;
    private final Transformer<? extends Collection<? extends ModelPath>, ? super ModelPath> suggestionsProvider;

    public UnboundRulesProcessor(Iterable<? extends RuleBinder> binders, Transformer<? extends Collection<? extends ModelPath>, ? super ModelPath> suggestionsProvider) {
        this.binders = binders;
        this.suggestionsProvider = suggestionsProvider;
    }

    public List<? extends UnboundRule> process() {
        ArrayList<UnboundRule> unboundRules = new ArrayList<UnboundRule>();
        for (RuleBinder ruleBinder : this.binders) {
            UnboundRule.Builder builder = UnboundRule.descriptor(String.valueOf(ruleBinder.getDescriptor()));
            ModelBinding subjectBinding = ruleBinder.getSubjectBinding();
            if (subjectBinding.getPredicate().getState().compareTo(ModelNode.State.Created) > 0) {
                UnboundRuleInput.Builder inputBuilder = this.toInputBuilder(subjectBinding);
                builder.mutableInput(inputBuilder);
            }
            for (int i = 0; i < ruleBinder.getInputBindings().size(); ++i) {
                ModelBinding binding = ruleBinder.getInputBindings().get(i);
                builder.immutableInput(this.toInputBuilder(binding));
            }
            unboundRules.add(builder.build());
        }
        return unboundRules;
    }

    private UnboundRuleInput.Builder toInputBuilder(ModelBinding binding) {
        ModelPath path;
        ModelReference<?> reference = binding.getPredicate().getReference();
        UnboundRuleInput.Builder builder = UnboundRuleInput.type(reference.getType());
        if (binding.isBound()) {
            builder.bound();
            path = binding.getNode().getPath();
        } else {
            ModelPath scope;
            path = reference.getPath();
            if (path != null) {
                builder.suggestions(CollectionUtils.stringize((Collection)((Collection)this.suggestionsProvider.transform((Object)path))));
            }
            if ((scope = reference.getScope()) != null && !scope.equals(ModelPath.ROOT)) {
                builder.scope(scope.toString());
            }
        }
        if (path != null) {
            builder.path(path);
        }
        builder.description(reference.getDescription());
        return builder;
    }
}

