/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisioningConfig
extends FeaturePackDepsConfig {
    private final Map<String, String> options;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
        return new Builder(provisioningConfig);
    }

    private ProvisioningConfig(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.options = CollectionUtils.unmodifiable(builder.options);
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean hasOption(String name) {
        return this.options.containsKey(name);
    }

    public String getOption(String name) {
        return this.options.get(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningConfig other = (ProvisioningConfig)obj;
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[');
        this.append(buf);
        if (!this.options.isEmpty()) {
            buf.append("options=");
            StringUtils.append(buf, this.options.entrySet());
        }
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private Map<String, String> options = Collections.emptyMap();

        private Builder() {
        }

        private Builder(ProvisioningConfig original) throws ProvisioningDescriptionException {
            if (original == null) {
                return;
            }
            if (original.hasOptions()) {
                this.addOptions(original.getOptions());
            }
            for (FeaturePackConfig fp : original.getFeaturePackDeps()) {
                this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
            }
            if (original.hasTransitiveDeps()) {
                for (FeaturePackConfig fp : original.getTransitiveDeps()) {
                    this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
                }
            }
            this.initUniverses(original);
            this.initConfigs(original);
        }

        public Builder addOption(String name, String value) {
            this.options = CollectionUtils.put(this.options, name, value);
            return this;
        }

        public Builder removeOption(String name) {
            this.options = CollectionUtils.remove(this.options, name);
            return this;
        }

        public Builder clearOptions() {
            this.options = Collections.emptyMap();
            return this;
        }

        public Builder addOptions(Map<String, String> options) {
            this.options = CollectionUtils.putAll(this.options, options);
            return this;
        }

        public ProvisioningConfig build() throws ProvisioningDescriptionException {
            return new ProvisioningConfig(this);
        }
    }
}

