/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter.collection;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.utils.StringUtils;

public abstract class AbstractArtifactFeatureFilter
extends AbstractArtifactsFilter {
    private List<String> includes;
    private List<String> excludes;

    public AbstractArtifactFeatureFilter(String include, String exclude) {
        this.setExcludes(exclude);
        this.setIncludes(include);
    }

    @Override
    public Set<Artifact> filter(Set<Artifact> artifacts) {
        Set<Artifact> results = artifacts;
        if (this.includes != null && !this.includes.isEmpty()) {
            results = this.filterIncludes(results, this.includes);
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            results = this.filterExcludes(results, this.excludes);
        }
        return results;
    }

    private Set<Artifact> filterIncludes(Set<Artifact> artifacts, List<String> theIncludes) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (String include : theIncludes) {
            for (Artifact artifact : artifacts) {
                if (!this.compareFeatures(this.getArtifactFeature(artifact), include)) continue;
                result.add(artifact);
            }
        }
        return result;
    }

    private Set<Artifact> filterExcludes(Set<Artifact> artifacts, List<String> theExcludes) {
        LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            boolean exclude = false;
            String artifactFeature = this.getArtifactFeature(artifact);
            for (String excludeFeature : theExcludes) {
                if (!this.compareFeatures(artifactFeature, excludeFeature)) continue;
                exclude = true;
                break;
            }
            if (exclude) continue;
            result.add(artifact);
        }
        return result;
    }

    protected abstract String getArtifactFeature(Artifact var1);

    public void setExcludes(String excludeString) {
        if (StringUtils.isNotEmpty(excludeString)) {
            this.excludes = Arrays.asList(StringUtils.split(excludeString, ","));
        }
    }

    public void setIncludes(String includeString) {
        if (StringUtils.isNotEmpty(includeString)) {
            this.includes = Arrays.asList(StringUtils.split(includeString, ","));
        }
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    protected boolean compareFeatures(String lhs, String rhs) {
        return lhs == null ? rhs == null : lhs.equals(rhs);
    }
}

