/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.RepositoryCache;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.execution.SettingsAdapter;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.aether.RepositorySystemSession;

public class MavenSession
implements Cloneable {
    private MavenExecutionRequest request;
    private MavenExecutionResult result;
    private RepositorySystemSession repositorySession;
    private Properties executionProperties;
    private MavenProject currentProject;
    private List<MavenProject> projects;
    private List<MavenProject> allProjects;
    private MavenProject topLevelProject;
    private ProjectDependencyGraph projectDependencyGraph;
    private boolean parallel;
    private final Map<String, Map<String, Map<String, Object>>> pluginContextsByProjectAndPluginKey = new ConcurrentHashMap<String, Map<String, Map<String, Object>>>();
    private Map<String, MavenProject> projectMap;
    private PlexusContainer container;
    private final Settings settings;

    public void setProjects(List<MavenProject> projects) {
        if (!projects.isEmpty()) {
            this.topLevelProject = this.currentProject = projects.get(0);
            for (MavenProject project : projects) {
                if (!project.isExecutionRoot()) continue;
                this.topLevelProject = project;
                break;
            }
        } else {
            this.currentProject = null;
            this.topLevelProject = null;
        }
        this.projects = projects;
    }

    public ArtifactRepository getLocalRepository() {
        return this.request.getLocalRepository();
    }

    public List<String> getGoals() {
        return this.request.getGoals();
    }

    public Properties getUserProperties() {
        return this.request.getUserProperties();
    }

    public Properties getSystemProperties() {
        return this.request.getSystemProperties();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<MavenProject> getProjects() {
        return this.projects;
    }

    public String getExecutionRootDirectory() {
        return this.request.getBaseDirectory();
    }

    public MavenExecutionRequest getRequest() {
        return this.request;
    }

    public void setCurrentProject(MavenProject currentProject) {
        this.currentProject = currentProject;
    }

    public MavenProject getCurrentProject() {
        return this.currentProject;
    }

    public ProjectBuildingRequest getProjectBuildingRequest() {
        return this.request.getProjectBuildingRequest().setRepositorySession(this.getRepositorySession());
    }

    public List<String> getPluginGroups() {
        return this.request.getPluginGroups();
    }

    public boolean isOffline() {
        return this.request.isOffline();
    }

    public MavenProject getTopLevelProject() {
        return this.topLevelProject;
    }

    public MavenExecutionResult getResult() {
        return this.result;
    }

    public Map<String, Object> getPluginContext(PluginDescriptor plugin, MavenProject project) {
        String pluginKey;
        Map<String, Object> pluginContext;
        String projectKey = project.getId();
        Map<String, Map<String, Object>> pluginContextsByKey = this.pluginContextsByProjectAndPluginKey.get(projectKey);
        if (pluginContextsByKey == null) {
            pluginContextsByKey = new ConcurrentHashMap<String, Map<String, Object>>();
            this.pluginContextsByProjectAndPluginKey.put(projectKey, pluginContextsByKey);
        }
        if ((pluginContext = pluginContextsByKey.get(pluginKey = plugin.getPluginLookupKey())) == null) {
            pluginContext = new ConcurrentHashMap<String, Object>();
            pluginContextsByKey.put(pluginKey, pluginContext);
        }
        return pluginContext;
    }

    public ProjectDependencyGraph getProjectDependencyGraph() {
        return this.projectDependencyGraph;
    }

    public void setProjectDependencyGraph(ProjectDependencyGraph projectDependencyGraph) {
        this.projectDependencyGraph = projectDependencyGraph;
    }

    public String getReactorFailureBehavior() {
        return this.request.getReactorFailureBehavior();
    }

    public MavenSession clone() {
        try {
            return (MavenSession)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Bug", e);
        }
    }

    public Date getStartTime() {
        return this.request.getStartTime();
    }

    public boolean isParallel() {
        return this.parallel;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    public RepositorySystemSession getRepositorySession() {
        return this.repositorySession;
    }

    public void setProjectMap(Map<String, MavenProject> projectMap) {
        this.projectMap = projectMap;
    }

    @Deprecated
    public Map<String, MavenProject> getProjectMap() {
        return this.projectMap;
    }

    public List<MavenProject> getAllProjects() {
        return this.allProjects;
    }

    public void setAllProjects(List<MavenProject> allProjects) {
        this.allProjects = allProjects;
    }

    @Deprecated
    public MavenSession(PlexusContainer container, RepositorySystemSession repositorySession, MavenExecutionRequest request, MavenExecutionResult result) {
        this.container = container;
        this.request = request;
        this.result = result;
        this.settings = new SettingsAdapter(request);
        this.repositorySession = repositorySession;
    }

    @Deprecated
    public MavenSession(PlexusContainer container, MavenExecutionRequest request, MavenExecutionResult result, MavenProject project) {
        this(container, request, result, Arrays.asList(project));
    }

    @Deprecated
    public MavenSession(PlexusContainer container, Settings settings, ArtifactRepository localRepository, EventDispatcher eventDispatcher, ReactorManager unused, List<String> goals, String executionRootDir, Properties executionProperties, Date startTime) {
        this(container, settings, localRepository, eventDispatcher, unused, goals, executionRootDir, executionProperties, null, startTime);
    }

    @Deprecated
    public MavenSession(PlexusContainer container, Settings settings, ArtifactRepository localRepository, EventDispatcher eventDispatcher, ReactorManager unused, List<String> goals, String executionRootDir, Properties executionProperties, Properties userProperties, Date startTime) {
        this.container = container;
        this.settings = settings;
        this.executionProperties = executionProperties;
        this.request = new DefaultMavenExecutionRequest();
        this.request.setUserProperties(userProperties);
        this.request.setLocalRepository(localRepository);
        this.request.setGoals(goals);
        this.request.setBaseDirectory(executionRootDir != null ? new File(executionRootDir) : null);
        this.request.setStartTime(startTime);
    }

    @Deprecated
    public MavenSession(PlexusContainer container, MavenExecutionRequest request, MavenExecutionResult result, List<MavenProject> projects) {
        this.container = container;
        this.request = request;
        this.result = result;
        this.settings = new SettingsAdapter(request);
        this.setProjects(projects);
    }

    @Deprecated
    public List<MavenProject> getSortedProjects() {
        return this.getProjects();
    }

    @Deprecated
    public RepositoryCache getRepositoryCache() {
        return null;
    }

    @Deprecated
    public EventDispatcher getEventDispatcher() {
        return null;
    }

    @Deprecated
    public boolean isUsingPOMsFromFilesystem() {
        return this.request.isProjectPresent();
    }

    @Deprecated
    public Properties getExecutionProperties() {
        if (this.executionProperties == null) {
            this.executionProperties = new Properties();
            this.executionProperties.putAll((Map<?, ?>)this.request.getSystemProperties());
            this.executionProperties.putAll((Map<?, ?>)this.request.getUserProperties());
        }
        return this.executionProperties;
    }

    @Deprecated
    public PlexusContainer getContainer() {
        return this.container;
    }

    @Deprecated
    public Object lookup(String role) throws ComponentLookupException {
        return this.container.lookup(role);
    }

    @Deprecated
    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.container.lookup(role, roleHint);
    }

    @Deprecated
    public List<Object> lookupList(String role) throws ComponentLookupException {
        return this.container.lookupList(role);
    }

    @Deprecated
    public Map<String, Object> lookupMap(String role) throws ComponentLookupException {
        return this.container.lookupMap(role);
    }
}

