export default class WorkspaceSettingsTab extends UI.VBox{constructor(){super();this.registerRequiredCSS('persistence/workspaceSettingsTab.css');const header=this.element.createChild('header');header.createChild('h1').createTextChild(Common.UIString('Workspace'));this.containerElement=this.element.createChild('div','settings-container-wrapper').createChild('div','settings-tab settings-content settings-container');Persistence.isolatedFileSystemManager.addEventListener(Persistence.IsolatedFileSystemManager.Events.FileSystemAdded,event=>this._fileSystemAdded((event.data)),this);Persistence.isolatedFileSystemManager.addEventListener(Persistence.IsolatedFileSystemManager.Events.FileSystemRemoved,event=>this._fileSystemRemoved((event.data)),this);const folderExcludePatternInput=this._createFolderExcludePatternInput();folderExcludePatternInput.classList.add('folder-exclude-pattern');this.containerElement.appendChild(folderExcludePatternInput);const div=this.containerElement.createChild('div','settings-info-message');div.createTextChild(Common.UIString('Mappings are inferred automatically.'));this._fileSystemsListContainer=this.containerElement.createChild('div','');const addButton=UI.createTextButton(ls`Add folder\u2026`,this._addFileSystemClicked.bind(this));this.containerElement.appendChild(addButton);this.setDefaultFocusedElement(addButton);this._elementByPath=new Map();this._mappingViewByPath=new Map();const fileSystems=Persistence.isolatedFileSystemManager.fileSystems();for(let i=0;i<fileSystems.length;++i){this._addItem(fileSystems[i]);}}
_createFolderExcludePatternInput(){const p=createElement('p');const labelElement=p.createChild('label');labelElement.textContent=ls`Folder exclude pattern`;const inputElement=UI.createInput('','text');UI.ARIAUtils.bindLabelToControl(labelElement,inputElement);p.appendChild(inputElement);inputElement.style.width='270px';const folderExcludeSetting=Persistence.isolatedFileSystemManager.workspaceFolderExcludePatternSetting();const setValue=UI.bindInput(inputElement,folderExcludeSetting.set.bind(folderExcludeSetting),regexValidator,false);folderExcludeSetting.addChangeListener(()=>setValue.call(null,folderExcludeSetting.get()));setValue(folderExcludeSetting.get());return p;function regexValidator(value){let regex;try{regex=new RegExp(value);}catch(e){}
const valid=!!regex;return{valid};}}
_addItem(fileSystem){if(!(fileSystem instanceof Persistence.IsolatedFileSystem)){return;}
const networkPersistenceProject=Persistence.networkPersistenceManager.project();if(networkPersistenceProject&&Persistence.isolatedFileSystemManager.fileSystem((networkPersistenceProject).fileSystemPath())===fileSystem){return;}
const element=this._renderFileSystem(fileSystem);this._elementByPath.set(fileSystem.path(),element);this._fileSystemsListContainer.appendChild(element);const mappingView=new Persistence.EditFileSystemView(fileSystem.path());this._mappingViewByPath.set(fileSystem.path(),mappingView);mappingView.element.classList.add('file-system-mapping-view');mappingView.show(element);}
_renderFileSystem(fileSystem){const fileSystemPath=fileSystem.path();const lastIndexOfSlash=fileSystemPath.lastIndexOf('/');const folderName=fileSystemPath.substr(lastIndexOfSlash+1);const element=createElementWithClass('div','file-system-container');const header=element.createChild('div','file-system-header');const nameElement=header.createChild('div','file-system-name');nameElement.textContent=folderName;UI.ARIAUtils.markAsHeading(nameElement,2);const path=header.createChild('div','file-system-path');path.textContent=fileSystemPath;path.title=fileSystemPath;const toolbar=new UI.Toolbar('');const button=new UI.ToolbarButton(Common.UIString('Remove'),'largeicon-delete');button.addEventListener(UI.ToolbarButton.Events.Click,this._removeFileSystemClicked.bind(this,fileSystem));toolbar.appendToolbarItem(button);header.appendChild(toolbar.element);return element;}
_removeFileSystemClicked(fileSystem){Persistence.isolatedFileSystemManager.removeFileSystem(fileSystem);}
_addFileSystemClicked(){Persistence.isolatedFileSystemManager.addFileSystem();}
_fileSystemAdded(fileSystem){this._addItem(fileSystem);}
_fileSystemRemoved(fileSystem){const mappingView=this._mappingViewByPath.get(fileSystem.path());if(mappingView){mappingView.dispose();this._mappingViewByPath.delete(fileSystem.path());}
const element=this._elementByPath.get(fileSystem.path());if(element){this._elementByPath.delete(fileSystem.path());element.remove();}}}
self.Persistence=self.Persistence||{};Persistence=Persistence||{};Persistence.WorkspaceSettingsTab=WorkspaceSettingsTab;