'\"
'\" Generated from file 'oometa\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2015 Sean Woods <yoda@etoyoc\&.com>
'\"
.TH "oometa" n 0\&.7\&.1 tcllib "Data registry for TclOO frameworks"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
oometa \- oo::meta A data registry for classess
.SH SYNOPSIS
\fBoo::meta::info\fR
.sp
\fBoo::meta::info branchget\fR ?\fIkey\fR? ?\&.\&.\&.?
.sp
\fBoo::meta::info branchset\fR ?\fIkey\&.\&.\&.\fR? \fIkey\fR \fIvalue\fR
.sp
\fBoo::meta::info dump\fR \fIclass\fR
.sp
\fBoo::meta::info\fR \fIclass\fR \fBis\fR \fItype\fR ?\fIargs\fR?
.sp
\fBoo::meta::info\fR \fIclass\fR \fBmerge\fR ?\fIdict\fR? ?\fIdict\fR? ?\fI\&.\&.\&.\fR?
.sp
\fBoo::meta::info\fR \fIclass\fR \fBrebuild\fR
.sp
\fBoo::meta::metadata\fR \fIclass\fR
.sp
\fBoo::define meta\fR
.sp
\fBoo::class method meta\fR
.sp
\fBoo::object method meta\fR
.sp
\fBoo::object method meta cget\fR ?\fIfield\fR? ?\fI\&.\&.\&.\fR? \fIfield\fR
.sp
.BE
.SH DESCRIPTION
The \fBoo::meta\fR package provides a data registry service for TclOO classes\&.
.SH USAGE
.CS


oo::class create animal {
  meta set biodata animal: 1
}
oo::class create mammal {
  superclass animal
  meta set biodata mammal: 1
}
oo::class create cat {
  superclass mammal
  meta set biodata diet: carnivore
}

cat create felix
puts [felix meta dump biodata]
> animal: 1 mammal: 1 diet: carnivore

felix meta set biodata likes: {birds mice}
puts [felix meta get biodata]
> animal: 1 mammal: 1 diet: carnivore likes: {bird mice}

# Modify a class
mammal meta set biodata metabolism: warm-blooded
puts [felix meta get biodata]
> animal: 1 mammal: 1 metabolism: warm-blooded diet: carnivore likes: {birds mice}

# Overwrite class info
felix meta set biodata mammal: yes
puts [felix meta get biodata]
> animal: 1 mammal: yes metabolism: warm-blooded diet: carnivore likes: {birds mice}

.CE
.SH CONCEPT
The concept behind \fBoo::meta\fR is that each class contributes a snippet of \fIlocal\fR data\&.
When \fBoo::meta::metadata\fR is called, the system walks through the linear ancestry produced by
\fBoo::meta::ancestors\fR, and recursively combines all of that local data for all of a class'
ancestors into a single dict\&.
Instances of oo::object can also combine class data with a local dict stored in the \fImeta\fR variable\&.
.SH COMMANDS
.TP
\fBoo::meta::info\fR
\fBoo::meta::info\fR is intended to work on the metadata of a class in a manner similar to if the aggregate
pieces where assembled into a single dict\&. The system mimics all of the standard dict commands, and addes
the following:
.TP
\fBoo::meta::info branchget\fR ?\fIkey\fR? ?\&.\&.\&.?
Returns a dict representation of the element at \fIargs\fR, but with any trailing : removed from field names\&.
.CS


::oo::meta::info $myclass set option color {default: green widget: colorselect}
puts [::oo::meta::info $myclass get option color]
> {default: green widget: color}
puts [::oo::meta::info $myclass branchget option color]
> {default green widget color}

.CE
.TP
\fBoo::meta::info branchset\fR ?\fIkey\&.\&.\&.\fR? \fIkey\fR \fIvalue\fR
Merges \fIdict\fR with any other information contaned at node ?\fIkey\&.\&.\&.\fR?, and adding a trailing :
to all field names\&.
.CS


::oo::meta::info $myclass branchset option color {default green widget colorselect}
puts [::oo::meta::info $myclass get option color]
> {default: green widget: color}

.CE
.TP
\fBoo::meta::info dump\fR \fIclass\fR
Returns the complete snapshot of a class metadata, as producted by \fBoo::meta::metadata\fR
.TP
\fBoo::meta::info\fR \fIclass\fR \fBis\fR \fItype\fR ?\fIargs\fR?
Returns a boolean true or false if the element ?\fIargs\fR? would match \fBstring is\fR \fItype\fR \fIvalue\fR
.CS


::oo::meta::info $myclass set constant mammal 1
puts [::oo::meta::info $myclass is true constant mammal]
> 1

.CE
.TP
\fBoo::meta::info\fR \fIclass\fR \fBmerge\fR ?\fIdict\fR? ?\fIdict\fR? ?\fI\&.\&.\&.\fR?
Combines all of the arguments into a single dict, which is then stored as the new
local representation for this class\&.
.TP
\fBoo::meta::info\fR \fIclass\fR \fBrebuild\fR
Forces the meta system to destroy any cached representation of a class' metadata before
the next access to \fBoo::meta::metadata\fR
.TP
\fBoo::meta::metadata\fR \fIclass\fR
Returns an aggregate picture of the metadata for \fIclass\fR, combining its \fIlocal\fR data
with the \fIlocal\fR data from its ancestors\&.
.TP
\fBoo::define meta\fR
The package injects a command \fBoo::define::meta\fR which works to provide a class in the
process of definition access to \fBoo::meta::info\fR, but without having to look the name up\&.
.CS


oo::define myclass {
  meta set foo bar: baz
}

.CE
.TP
\fBoo::class method meta\fR
The package injects a new method \fBmeta\fR into \fBoo::class\fR which works to provide a class
instance access to \fBoo::meta::info\fR\&.
.TP
\fBoo::object method meta\fR
The package injects a new method \fBmeta\fR into \fBoo::object\fR\&. \fBoo::object\fR combines the data
for its class (as provided by \fBoo::meta::metadata\fR), with a local variable \fImeta\fR to
produce a local picture of metadata\&.
This method provides the following additional commands:
.TP
\fBoo::object method meta cget\fR ?\fIfield\fR? ?\fI\&.\&.\&.\fR? \fIfield\fR
Attempts to locate a singlar leaf, and return its value\&. For single option lookups, this
is faster than \fBmy meta getnull\fR ?\fIfield\fR? ?\fI\&.\&.\&.\fR? \fIfield\fR], because
it performs a search instead directly instead of producing the recursive merge product
between the class metadata, the local \fImeta\fR variable, and THEN performing the search\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fItcloo\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
TOOL, TclOO
.SH CATEGORY
TclOO
.SH COPYRIGHT
.nf
Copyright (c) 2015 Sean Woods <yoda@etoyoc\&.com>

.fi