/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.scanner.RegexAutoTagScanner;

public class PassiveScanParam
extends AbstractParam {
    private static final Logger logger = Logger.getLogger(PassiveScanParam.class);
    static final String PASSIVE_SCANS_BASE_KEY = "pscans";
    private static final String ALL_AUTO_TAG_SCANNERS_KEY = "pscans.autoTagScanners.scanner";
    private static final String AUTO_TAG_SCANNER_NAME_KEY = "name";
    private static final String AUTO_TAG_SCANNER_TYPE_KEY = "type";
    private static final String AUTO_TAG_SCANNER_CONFIG_KEY = "config";
    private static final String AUTO_TAG_SCANNER_REQ_URL_REGEX_KEY = "reqUrlRegex";
    private static final String AUTO_TAG_SCANNER_REQ_HEAD_REGEX_KEY = "reqHeadRegex";
    private static final String AUTO_TAG_SCANNER_RES_HEAD_REGEX_KEY = "resHeadRegex";
    private static final String AUTO_TAG_SCANNER_RES_BODY_REGEX_KEY = "resBodyRegex";
    private static final String AUTO_TAG_SCANNER_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_AUTO_TAG_SCANNER_KEY = "pscans.confirmRemoveAutoTagScanner";
    private static final String SCAN_ONLY_IN_SCOPE_KEY = "pscans.scanOnlyInScope";
    private static final String SCAN_FUZZER_MESSAGES_KEY = "pscans.scanFuzzerMessages";
    private static final String MAX_ALERTS_PER_RULE = "pscans.maxAlertsPerRule";
    private List<RegexAutoTagScanner> autoTagScanners = new ArrayList<RegexAutoTagScanner>(0);
    private boolean confirmRemoveAutoTagScanner = true;
    private boolean scanOnlyInScope;
    private boolean scanFuzzerMessages;
    private int maxAlertsPerRule;

    @Override
    protected void parse() {
        try {
            List fields = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(ALL_AUTO_TAG_SCANNERS_KEY);
            this.autoTagScanners = new ArrayList<RegexAutoTagScanner>(fields.size());
            ArrayList<String> tempListNames = new ArrayList<String>(fields.size());
            for (HierarchicalConfiguration sub : fields) {
                String name = sub.getString(AUTO_TAG_SCANNER_NAME_KEY, "");
                if ("".equals(name) || tempListNames.contains(name)) continue;
                tempListNames.add(name);
                RegexAutoTagScanner app = new RegexAutoTagScanner(sub.getString(AUTO_TAG_SCANNER_NAME_KEY), RegexAutoTagScanner.TYPE.valueOf(sub.getString(AUTO_TAG_SCANNER_TYPE_KEY)), sub.getString(AUTO_TAG_SCANNER_CONFIG_KEY), sub.getString(AUTO_TAG_SCANNER_REQ_URL_REGEX_KEY), sub.getString(AUTO_TAG_SCANNER_REQ_HEAD_REGEX_KEY), sub.getString(AUTO_TAG_SCANNER_RES_HEAD_REGEX_KEY), sub.getString(AUTO_TAG_SCANNER_RES_BODY_REGEX_KEY), sub.getBoolean(AUTO_TAG_SCANNER_ENABLED_KEY, true));
                this.autoTagScanners.add(app);
            }
        }
        catch (ConversionException e) {
            logger.error((Object)("Error while loading the auto tag scanners: " + e.getMessage()), (Throwable)e);
        }
        this.confirmRemoveAutoTagScanner = this.getBoolean(CONFIRM_REMOVE_AUTO_TAG_SCANNER_KEY, true);
        this.scanOnlyInScope = this.getBoolean(SCAN_ONLY_IN_SCOPE_KEY, false);
        this.scanFuzzerMessages = this.getBoolean(SCAN_FUZZER_MESSAGES_KEY, false);
        this.setFuzzerOptin(this.scanFuzzerMessages);
        this.maxAlertsPerRule = this.getInt(MAX_ALERTS_PER_RULE, 0);
    }

    public void setAutoTagScanners(List<RegexAutoTagScanner> scanners) {
        this.autoTagScanners = scanners;
        ((HierarchicalConfiguration)this.getConfig()).clearTree(ALL_AUTO_TAG_SCANNERS_KEY);
        int size = scanners.size();
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "pscans.autoTagScanners.scanner(" + i + ").";
            RegexAutoTagScanner scanner = scanners.get(i);
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_NAME_KEY, (Object)scanner.getName());
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_TYPE_KEY, (Object)scanner.getType().toString());
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_CONFIG_KEY, (Object)scanner.getConf());
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_REQ_URL_REGEX_KEY, (Object)scanner.getRequestUrlRegex());
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_REQ_HEAD_REGEX_KEY, (Object)scanner.getRequestHeaderRegex());
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_RES_HEAD_REGEX_KEY, (Object)scanner.getResponseHeaderRegex());
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_RES_BODY_REGEX_KEY, (Object)scanner.getResponseBodyRegex());
            this.getConfig().setProperty(elementBaseKey + AUTO_TAG_SCANNER_ENABLED_KEY, (Object)scanner.isEnabled());
        }
    }

    public List<RegexAutoTagScanner> getAutoTagScanners() {
        return this.autoTagScanners;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveAutoTagScanner() {
        return this.confirmRemoveAutoTagScanner;
    }

    @ZapApiIgnore
    public void setConfirmRemoveAutoTagScanner(boolean confirmRemove) {
        this.confirmRemoveAutoTagScanner = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_AUTO_TAG_SCANNER_KEY, (Object)this.confirmRemoveAutoTagScanner);
    }

    public void setScanOnlyInScope(boolean scanOnlyInScope) {
        this.scanOnlyInScope = scanOnlyInScope;
        this.getConfig().setProperty(SCAN_ONLY_IN_SCOPE_KEY, (Object)scanOnlyInScope);
    }

    public boolean isScanOnlyInScope() {
        return this.scanOnlyInScope;
    }

    public void setScanFuzzerMessages(boolean scanFuzzerMessages) {
        this.scanFuzzerMessages = scanFuzzerMessages;
        this.getConfig().setProperty(SCAN_FUZZER_MESSAGES_KEY, (Object)scanFuzzerMessages);
        this.setFuzzerOptin(scanFuzzerMessages);
    }

    private void setFuzzerOptin(boolean shouldOptin) {
        if (shouldOptin) {
            PassiveScanThread.addApplicableHistoryType(8);
            PassiveScanThread.addApplicableHistoryType(20);
        } else {
            PassiveScanThread.removeApplicableHistoryType(8);
            PassiveScanThread.removeApplicableHistoryType(20);
        }
    }

    public boolean isScanFuzzerMessages() {
        return this.scanFuzzerMessages;
    }

    public int getMaxAlertsPerRule() {
        return this.maxAlertsPerRule;
    }

    public void setMaxAlertsPerRule(int maxAlertsPerRule) {
        this.maxAlertsPerRule = maxAlertsPerRule;
        this.getConfig().setProperty(MAX_ALERTS_PER_RULE, (Object)maxAlertsPerRule);
    }
}

