/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropPackage", description="Drops an existing package", priority=101, appliesTo={"package"})
public class DropPackageChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String packageName;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, this);
    }

    @DatabaseChangeProperty(mustEqualExisting="package.catalog")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="package.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="package", description="Name of the package to drop")
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    @Override
    public String getConfirmationMessage() {
        return "Package " + this.getPackageName() + " dropped";
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropPackageStatement(this.getCatalogName(), this.getSchemaName(), this.getPackageName())};
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

