/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class AuroProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("M(dddd)").number("Td+").number("I(d+)").number("Ed+W").text("*****").number("d{8}d{4}").expression(".{8}#.{8}").number("d{10}").number("([-+])(ddd)(dd)(dddd)").number("([-+])(ddd)(dd)(dddd)").number("(dd)(dd)(dddd)").number("(dd)(dd)(dd)").number("(ddd)").number("d{6}").number("(ddd)").number("d").number("(dd)").expression("([01])").compile();

    public AuroProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.set("index", parser.nextInt(0));
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setValid(true);
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_MIN));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG_MIN_MIN));
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setCourse(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.set("battery", parser.nextInt(0));
        position.set("charge", parser.nextInt(0) == 1);
        return position;
    }
}

