/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.LinkedList;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class At2000ProtocolDecoder
extends BaseProtocolDecoder {
    private static final int BLOCK_LENGTH = 16;
    public static final int MSG_ACKNOWLEDGEMENT = 0;
    public static final int MSG_DEVICE_ID = 1;
    public static final int MSG_TRACK_REQUEST = 136;
    public static final int MSG_TRACK_RESPONSE = 137;
    public static final int MSG_SESSION_END = 12;
    private Cipher cipher;

    public At2000ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static void sendRequest(Channel channel) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)16);
            response.writeByte(136);
            response.writeMedium(0);
            response.writerIndex(16);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getUnsignedByte(buf.readerIndex()) == 1) {
            buf.readUnsignedByte();
        }
        short type = buf.readUnsignedByte();
        buf.readUnsignedMediumLE();
        buf.skipBytes(12);
        if (type == 1) {
            String imei = buf.readSlice(15).toString(StandardCharsets.US_ASCII);
            if (this.getDeviceSession(channel, remoteAddress, imei) != null) {
                byte[] iv = new byte[16];
                buf.readBytes(iv);
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                SecretKeySpec keySpec = new SecretKeySpec(DataConverter.parseHex("000102030405060708090a0b0c0d0e0f"), "AES");
                this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
                this.cipher.init(2, (Key)keySpec, ivSpec);
                byte[] data = new byte[16];
                buf.readBytes(data);
                this.cipher.update(data);
            }
        } else if (type == 137) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            if (buf.capacity() <= 16) {
                return null;
            }
            LinkedList<Position> positions = new LinkedList<Position>();
            byte[] data = new byte[buf.capacity() - 16];
            buf.readBytes(data);
            buf = Unpooled.wrappedBuffer((byte[])this.cipher.update(data));
            try {
                while (buf.readableBytes() >= 63) {
                    Position position = new Position(this.getProtocolName());
                    position.setDeviceId(deviceSession.getDeviceId());
                    buf.readUnsignedShortLE();
                    buf.readUnsignedShortLE();
                    position.setValid(true);
                    position.setTime(new Date(buf.readLongLE() * 1000L));
                    position.setLatitude(buf.readFloatLE());
                    position.setLongitude(buf.readFloatLE());
                    position.setAltitude(buf.readFloatLE());
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readFloatLE()));
                    position.setCourse(buf.readFloatLE());
                    buf.readUnsignedIntLE();
                    buf.readUnsignedIntLE();
                    buf.readUnsignedIntLE();
                    buf.readUnsignedIntLE();
                    buf.readUnsignedShortLE();
                    position.set("adc1", buf.readUnsignedShortLE());
                    position.set("adc1", buf.readUnsignedShortLE());
                    position.set("power", (double)buf.readUnsignedShortLE() * 0.001);
                    buf.readUnsignedShortLE();
                    position.set("rssi", buf.readUnsignedByte());
                    buf.readUnsignedByte();
                    position.set("battery", buf.readUnsignedByte());
                    position.set("temp1", buf.readUnsignedByte());
                    position.set("sat", buf.readUnsignedByte());
                    positions.add(position);
                }
            }
            finally {
                buf.release();
            }
            return positions;
        }
        if (type == 1) {
            At2000ProtocolDecoder.sendRequest(channel);
        }
        return null;
    }
}

