/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import io.netty.channel.ChannelHandler;
import java.util.Collections;
import java.util.Map;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.IdentityManager;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Event;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class BehaviorEventHandler
extends BaseEventHandler {
    private final double accelerationThreshold;
    private final double brakingThreshold;
    private final IdentityManager identityManager;

    public BehaviorEventHandler(Config config, IdentityManager identityManager) {
        this.accelerationThreshold = config.getDouble(Keys.EVENT_BEHAVIOR_ACCELERATION_THRESHOLD);
        this.brakingThreshold = config.getDouble(Keys.EVENT_BEHAVIOR_BRAKING_THRESHOLD);
        this.identityManager = identityManager;
    }

    @Override
    protected Map<Event, Position> analyzePosition(Position position) {
        Position lastPosition = this.identityManager.getLastPosition(position.getDeviceId());
        if (lastPosition != null && position.getFixTime().equals(lastPosition.getFixTime())) {
            double acceleration = UnitsConverter.mpsFromKnots(position.getSpeed() - lastPosition.getSpeed()) * 1000.0 / (double)(position.getFixTime().getTime() - lastPosition.getFixTime().getTime());
            if (this.accelerationThreshold != 0.0 && acceleration >= this.accelerationThreshold) {
                Event event = new Event("alarm", position);
                event.set("alarm", "hardAcceleration");
                return Collections.singletonMap(event, position);
            }
            if (this.brakingThreshold != 0.0 && acceleration <= -this.brakingThreshold) {
                Event event = new Event("alarm", position);
                event.set("alarm", "hardBraking");
                return Collections.singletonMap(event, position);
            }
        }
        return null;
    }
}

