/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.StatisticsManager;
import org.traccar.geolocation.GeolocationProvider;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class GeolocationHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeolocationHandler.class);
    private final GeolocationProvider geolocationProvider;
    private final StatisticsManager statisticsManager;
    private final boolean processInvalidPositions;

    public GeolocationHandler(Config config, GeolocationProvider geolocationProvider, StatisticsManager statisticsManager) {
        this.geolocationProvider = geolocationProvider;
        this.statisticsManager = statisticsManager;
        this.processInvalidPositions = config.getBoolean(Keys.GEOLOCATION_PROCESS_INVALID_POSITIONS);
    }

    public void channelRead(final ChannelHandlerContext ctx, Object message) {
        if (message instanceof Position) {
            final Position position = (Position)message;
            if ((position.getOutdated() || this.processInvalidPositions && !position.getValid()) && position.getNetwork() != null) {
                if (this.statisticsManager != null) {
                    this.statisticsManager.registerGeolocationRequest();
                }
                this.geolocationProvider.getLocation(position.getNetwork(), new GeolocationProvider.LocationProviderCallback(){

                    @Override
                    public void onSuccess(double latitude, double longitude, double accuracy) {
                        position.set("approximate", true);
                        position.setValid(true);
                        position.setFixTime(position.getDeviceTime());
                        position.setLatitude(latitude);
                        position.setLongitude(longitude);
                        position.setAccuracy(accuracy);
                        position.setAltitude(0.0);
                        position.setSpeed(0.0);
                        position.setCourse(0.0);
                        ctx.fireChannelRead((Object)position);
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        LOGGER.warn("Geolocation network error", e);
                        ctx.fireChannelRead((Object)position);
                    }
                });
            } else {
                ctx.fireChannelRead((Object)position);
            }
        } else {
            ctx.fireChannelRead(message);
        }
    }
}

