/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.model.Event;
import org.traccar.model.Notification;
import org.traccar.model.Typed;
import org.traccar.notification.MessageException;

@Path(value="notifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationResource
extends ExtendedObjectResource<Notification> {
    public NotificationResource() {
        super(Notification.class);
    }

    @GET
    @Path(value="types")
    public Collection<Typed> get() {
        return Context.getNotificationManager().getAllNotificationTypes();
    }

    @GET
    @Path(value="notificators")
    public Collection<Typed> getNotificators() {
        return Context.getNotificatorManager().getAllNotificatorTypes();
    }

    @POST
    @Path(value="test")
    public Response testMessage() throws MessageException, InterruptedException {
        for (Typed method : Context.getNotificatorManager().getAllNotificatorTypes()) {
            Context.getNotificatorManager().getNotificator(method.getType()).sendSync(this.getUserId(), new Event("test", 0L), null);
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="test/{notificator}")
    public Response testMessage(@PathParam(value="notificator") String notificator) throws MessageException, InterruptedException {
        Context.getNotificatorManager().getNotificator(notificator).sendSync(this.getUserId(), new Event("test", 0L), null);
        return Response.noContent().build();
    }
}

