/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import javax.ws.rs.GET;
import javax.ws.rs.QueryParam;
import org.traccar.Context;
import org.traccar.api.BaseObjectResource;
import org.traccar.database.ExtendedObjectManager;
import org.traccar.model.BaseModel;

public class ExtendedObjectResource<T extends BaseModel>
extends BaseObjectResource<T> {
    public ExtendedObjectResource(Class<T> baseClass) {
        super(baseClass);
    }

    @GET
    public Collection<T> get(@QueryParam(value="all") boolean all, @QueryParam(value="userId") long userId, @QueryParam(value="groupId") long groupId, @QueryParam(value="deviceId") long deviceId, @QueryParam(value="refresh") boolean refresh) throws SQLException {
        ExtendedObjectManager manager = (ExtendedObjectManager)Context.getManager(this.getBaseClass());
        if (refresh) {
            manager.refreshItems();
        }
        HashSet<Long> result = new HashSet<Long>(this.getSimpleManagerItems(manager, all, userId));
        if (groupId != 0L) {
            Context.getPermissionsManager().checkGroup(this.getUserId(), groupId);
            result.retainAll(manager.getGroupItems(groupId));
        }
        if (deviceId != 0L) {
            Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
            result.retainAll(manager.getDeviceItems(deviceId));
        }
        return manager.getItems(result);
    }
}

