/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;

public abstract class AbstractProcessingInstruction
extends AbstractNode
implements ProcessingInstruction {
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String asXML() {
        return "<?" + this.getName() + " " + this.getText() + "?>";
    }

    public String getName() {
        return this.getTarget();
    }

    public short getNodeType() {
        return 7;
    }

    public String getPath(Element context) {
        Element parent = this.getParent();
        return parent != null && parent != context ? String.valueOf(parent.getPath(context)) + "/processing-instruction()" : "processing-instruction()";
    }

    public abstract String getTarget();

    public String getUniquePath(Element context) {
        Element parent = this.getParent();
        return parent != null && parent != context ? String.valueOf(parent.getUniquePath(context)) + "/processing-instruction()" : "processing-instruction()";
    }

    public abstract String getValue(String var1);

    public abstract Map getValues();

    protected Map parseValues(String text) {
        HashMap<String, String> data = new HashMap<String, String>();
        StringTokenizer s = new StringTokenizer(text);
        while (s.hasMoreTokens()) {
            StringTokenizer t = new StringTokenizer(s.nextToken(), "='\"");
            if (t.countTokens() < 2) continue;
            String name = t.nextToken();
            String value = t.nextToken();
            data.put(name, value);
        }
        return data;
    }

    public boolean removeValue(String name) {
        return false;
    }

    public void setName(String name) {
        this.setTarget(name);
    }

    public abstract void setTarget(String var1);

    public void setValue(String name, String value) {
        throw new UnsupportedOperationException("This PI is read-only and cannot be modified");
    }

    public void setValues(Map data) {
        throw new UnsupportedOperationException("This PI is read-only and cannot be modified");
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [ProcessingInstruction: &" + this.getName() + ";]";
    }

    protected String toString(Map values) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = values.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            buffer.append(name);
            buffer.append("=\"");
            buffer.append(value);
            buffer.append("\" ");
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public void write(Writer writer) throws IOException {
        writer.write("<?");
        writer.write(this.getName());
        writer.write(" ");
        writer.write(this.getText());
        writer.write("?>");
    }
}

