/*
 * Decompiled with CFR 0.152.
 */
package tr.view.collect.screen;

import java.util.logging.Logger;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.thought.Thought;
import tr.model.util.Manager;
import tr.util.Observable;
import tr.view.collect.DeleteThoughtCookie;
import tr.view.collect.EditThoughtCookie;
import tr.view.collect.dialog.ThoughtDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThoughtNode
extends AbstractNode
implements EditThoughtCookie,
DeleteThoughtCookie {
    private static final Logger LOG = Logger.getLogger("tr.view.collect");
    public final Manager<Thought> manager;
    public final Thought thought;

    public ThoughtNode(Manager<Thought> manager, Thought thought) {
        super(Children.LEAF, Lookups.singleton((Object)thought));
        this.manager = manager;
        this.thought = thought;
    }

    public String getName() {
        return this.thought.getDescription();
    }

    public Node.Cookie getCookie(Class clazz) {
        if (clazz == EditThoughtCookie.class) {
            return this;
        }
        if (clazz == DeleteThoughtCookie.class) {
            return this;
        }
        return super.getCookie(clazz);
    }

    @Override
    public void editThought() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data != null) {
            new ThoughtDialog(data).showModifyDialog(this.thought);
        }
    }

    @Override
    public void deleteThought() {
        this.manager.remove((Observable)this.thought);
    }
}

