/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventType;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.TriggerBase;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerUtils;
import org.apache.solr.cloud.autoscaling.TriggerValidationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricTrigger
extends TriggerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String metric;
    private Number above;
    private Number below;
    private String collection;
    private String shard;
    private String node;
    private String preferredOp;
    private final Map<String, Long> lastNodeEvent = new ConcurrentHashMap<String, Long>();

    public MetricTrigger(String name) {
        super(TriggerEventType.METRIC, name);
        TriggerUtils.requiredProperties(this.requiredProperties, this.validProperties, "metric");
        TriggerUtils.validProperties(this.validProperties, "above", "below", "preferredOperation", "collection", "shard", "node");
    }

    @Override
    public void configure(SolrResourceLoader loader, SolrCloudManager cloudManager, Map<String, Object> properties) throws TriggerValidationException {
        super.configure(loader, cloudManager, properties);
        this.metric = (String)properties.get("metric");
        this.above = (Number)properties.get("above");
        this.below = (Number)properties.get("below");
        this.collection = (String)properties.getOrDefault("collection", "#ANY");
        this.shard = (String)properties.getOrDefault("shard", "#ANY");
        if (this.collection.equals("#ANY") && !this.shard.equals("#ANY")) {
            throw new TriggerValidationException("shard", "When 'shard' is other than #ANY then collection name must be also other than #ANY");
        }
        this.node = (String)properties.getOrDefault("node", "#ANY");
        this.preferredOp = (String)properties.getOrDefault("preferredOperation", CollectionParams.CollectionAction.MOVEREPLICA.toLower());
    }

    @Override
    protected Map<String, Object> getState() {
        return null;
    }

    @Override
    protected void setState(Map<String, Object> state) {
        this.lastNodeEvent.clear();
        Map nodeTimes = (Map)state.get("lastNodeEvent");
        if (nodeTimes != null) {
            this.lastNodeEvent.putAll(nodeTimes);
        }
    }

    @Override
    public void restoreState(AutoScaling.Trigger old) {
        MetricTrigger that;
        assert (old.isClosed());
        if (old instanceof MetricTrigger) {
            that = (MetricTrigger)old;
            assert (this.name.equals(that.name));
        } else {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Unable to restore state from an unknown type of trigger");
        }
        this.lastNodeEvent.clear();
        this.lastNodeEvent.putAll(that.lastNodeEvent);
    }

    @Override
    public void run() {
        AutoScaling.TriggerEventProcessor processor = (AutoScaling.TriggerEventProcessor)this.processorRef.get();
        if (processor == null) {
            return;
        }
        HashSet liveNodes = null;
        if (this.node.equals("#ANY")) {
            if (this.collection.equals("#ANY")) {
                liveNodes = this.cloudManager.getClusterStateProvider().getLiveNodes();
            } else {
                DocCollection docCollection;
                HashSet nodes = new HashSet();
                ClusterState.CollectionRef ref = this.cloudManager.getClusterStateProvider().getState(this.collection);
                if (ref == null || (docCollection = ref.get()) == null) {
                    log.warn("MetricTrigger could not find collection: {}", (Object)this.collection);
                    return;
                }
                if (this.shard.equals("#ANY")) {
                    docCollection.getReplicas().forEach(replica -> nodes.add(replica.getNodeName()));
                } else {
                    Slice slice = docCollection.getSlice(this.shard);
                    if (slice == null) {
                        log.warn("MetricTrigger could not find collection: {} shard: {}", (Object)this.collection, (Object)this.shard);
                        return;
                    }
                    slice.getReplicas().forEach(replica -> nodes.add(replica.getNodeName()));
                }
                liveNodes = nodes;
            }
        } else {
            liveNodes = Collections.singleton(this.node);
        }
        HashMap rates = new HashMap(liveNodes.size());
        for (String node2 : liveNodes) {
            Map values = this.cloudManager.getNodeStateProvider().getNodeValues(node2, Collections.singletonList(this.metric));
            values.forEach((tag, rate) -> rates.computeIfAbsent(node2, s -> (Number)rate));
        }
        long now = this.cloudManager.getTimeSource().getTimeNs();
        Map<String, Number> hotNodes = rates.entrySet().stream().filter(entry -> this.waitForElapsed((String)entry.getKey(), now, this.lastNodeEvent)).filter(entry -> this.below != null && Double.compare(((Number)entry.getValue()).doubleValue(), this.below.doubleValue()) < 0 || this.above != null && Double.compare(((Number)entry.getValue()).doubleValue(), this.above.doubleValue()) > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (hotNodes.isEmpty()) {
            return;
        }
        AtomicLong eventTime = new AtomicLong(now);
        hotNodes.forEach((n, r) -> {
            long time = this.lastNodeEvent.get(n);
            if (eventTime.get() > time) {
                eventTime.set(time);
            }
        });
        if (processor.process(new MetricBreachedEvent(this.getName(), this.collection, this.shard, this.preferredOp, eventTime.get(), this.metric, hotNodes))) {
            hotNodes.keySet().forEach(node -> this.lastNodeEvent.put((String)node, now));
        }
    }

    private boolean waitForElapsed(String name, long now, Map<String, Long> lastEventMap) {
        Long lastTime = lastEventMap.computeIfAbsent(name, s -> now);
        long elapsed = TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS);
        log.trace("name={}, lastTime={}, elapsed={}", new Object[]{name, lastTime, elapsed});
        return TimeUnit.SECONDS.convert(now - lastTime, TimeUnit.NANOSECONDS) >= (long)this.getWaitForSecond();
    }

    public static class MetricBreachedEvent
    extends TriggerEvent {
        public MetricBreachedEvent(String source, String collection, String shard, String preferredOp, long eventTime, String metric, Map<String, Number> hotNodes) {
            super(TriggerEventType.METRIC, source, eventTime, null);
            this.properties.put("metric", metric);
            this.properties.put("node", hotNodes);
            if (!collection.equals("#ANY")) {
                this.properties.put("collection", collection);
            }
            if (!shard.equals("#ANY")) {
                this.properties.put("shard", shard);
            }
            this.properties.put("preferredOperation", preferredOp);
            ArrayList<TriggerEvent.Op> ops = new ArrayList<TriggerEvent.Op>(hotNodes.size());
            for (String n : hotNodes.keySet()) {
                TriggerEvent.Op op = new TriggerEvent.Op(CollectionParams.CollectionAction.get((String)preferredOp));
                op.addHint(Suggester.Hint.SRC_NODE, n);
                if (!collection.equals("#ANY")) {
                    if (!shard.equals("#ANY")) {
                        op.addHint(Suggester.Hint.COLL_SHARD, new Pair((Object)collection, (Object)shard));
                    } else {
                        op.addHint(Suggester.Hint.COLL, collection);
                    }
                }
                ops.add(op);
            }
            this.properties.put("requestedOps", ops);
        }
    }
}

