/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jaeger;

import io.jaegertracing.Configuration;
import io.opentracing.Tracer;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.TracerConfigurator;

public class JaegerTracerConfigurator
extends TracerConfigurator {
    public static final String AGENT_HOST = "agentHost";
    public static final String AGENT_PORT = "agentPort";
    public static final String LOG_SPANS = "logSpans";
    public static final String FLUSH_INTERVAL = "flushInterval";
    public static final String MAX_QUEUE_SIZE = "maxQueueSize";
    private volatile Tracer tracer;

    public Tracer getTracer() {
        return this.tracer;
    }

    public void init(NamedList args) {
        Object flushIntervalArg;
        Object host = args.get(AGENT_HOST);
        if (!(host instanceof String)) {
            throw new IllegalArgumentException("Expected a required string for param 'agentHost'");
        }
        Object portArg = args.get(AGENT_PORT);
        if (!(portArg instanceof Integer)) {
            throw new IllegalArgumentException("Expected a required int for param 'agentPort'");
        }
        int port = (Integer)portArg;
        Boolean logSpans = args.getBooleanArg(LOG_SPANS);
        if (logSpans == null) {
            logSpans = true;
        }
        if ((flushIntervalArg = args.get(FLUSH_INTERVAL)) != null && !(flushIntervalArg instanceof Integer)) {
            throw new IllegalArgumentException("Expected a required int for param 'flushInterval'");
        }
        int flushInterval = flushIntervalArg == null ? 1000 : (Integer)flushIntervalArg;
        Object maxQueueArgs = args.get(MAX_QUEUE_SIZE);
        if (maxQueueArgs != null && !(maxQueueArgs instanceof Integer)) {
            throw new IllegalArgumentException("Expected a required int for param 'maxQueueSize'");
        }
        int maxQueue = maxQueueArgs == null ? 10000 : (Integer)maxQueueArgs;
        Configuration.SamplerConfiguration samplerConfig = new Configuration.SamplerConfiguration().withType("const").withParam((Number)1);
        Configuration.ReporterConfiguration reporterConfig = Configuration.ReporterConfiguration.fromEnv();
        Configuration.SenderConfiguration senderConfig = reporterConfig.getSenderConfiguration().withAgentHost(host.toString()).withAgentPort(Integer.valueOf(port));
        reporterConfig.withLogSpans(logSpans).withFlushInterval(Integer.valueOf(flushInterval)).withMaxQueueSize(Integer.valueOf(maxQueue)).withSender(senderConfig);
        this.tracer = new Configuration("solr").withSampler(samplerConfig).withReporter(reporterConfig).getTracer();
    }
}

