// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _OSD_HeaderFile
#define _OSD_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Standard_Real.hxx>
#include <Standard_PCharacter.hxx>
#include <Standard_CString.hxx>
class OSD_Error;
class OSD_Protection;
class OSD_Path;
class OSD_FileNode;
class OSD_Disk;
class OSD_File;
class OSD_FileIterator;
class OSD_Directory;
class OSD_DirectoryIterator;
class OSD_Chronometer;
class OSD_Timer;
class OSD_Printer;
class OSD_Host;
class OSD_Environment;
class OSD_EnvironmentIterator;
class OSD_Process;
class OSD_SharedLibrary;
class OSD_Thread;


//! Set of Operating Sytem Dependent Tools
//! (O)perating (S)ystem (D)ependent
class OSD 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! A tool to manage threads
  //!
  //! Sets signal and exception handlers.
  //! <b>Windows-specific notes<\b>
  //! Compiled with MS VC++ sets 3 main handlers:
  //! @li Signal handlers (via ::signal() functions) that translate system signals
  //! (SIGSEGV, SIGFPE, SIGILL) into C++ exceptions (classes inheriting
  //! Standard_Failure). They only be called if user calls ::raise() function
  //! with one of supported signal type set.
  //! @li Exception handler OSD::WntHandler() (via ::SetUnhandledExceptionFilter())
  //! that will be used when user's code is compiled with /EHs option.
  //! @li Structured exception (SE) translator (via _set_se_translator()) that
  //! translates SE exceptions (aka asynchronous exceptions) into the
  //! C++ exceptions inheriting Standard_Failure. This translator will be
  //! used when user's code is compiled with /EHa option.
  //!
  //! This approach ensures that regardless of the option the user chooses to
  //! compile his code with (/EHs or /EHa), signals (or SE exceptions) will be
  //! translated into Open CASCADE C++ exceptions.
  //!
  //! If @a theFloatingSignal is TRUE then floating point exceptions will be
  //! generated in accordance with the mask
  //! <tt>_EM_INVALID | _EM_DENORMAL | _EM_ZERODIVIDE | _EM_OVERFLOW<\tt> that is
  //! used to call ::_controlfp() system function. If @a theFloatingSignal is FALSE
  //! corresponding operations (e.g. division by zero) will gracefully complete
  //! without an exception.
  //!
  //! <b>Unix-specific notes<\b>
  //! OSD::SetSignal() sets handlers (via ::sigaction()) for multiple signals
  //! (SIGFPE, SIGSEGV, etc). Currently the number of handled signals is much
  //! greater than for Windows, in the future this may change to provide better
  //! consistency with Windows.
  //!
  //! @a theFloatingSignal is recognized on Sun Solaris, Linux, and SGI Irix to
  //! generate floating-point exception according to the mask
  //! <tt>FE_INVALID | FE_DIVBYZERO | FE_OVERFLOW</tt> (in Linux conventions).<br>
  //! When compiled with OBJS macro defined, already set signal handlers (e.g.
  //! by Data Base Managers) are not redefined.
  //!
  //! <b>Common notes<\b>
  //! If OSD::SetSignal() method is used in at least one thread, it must also be
  //! called in any other thread where Open CASCADE will be used, to ensure
  //! consistency of behavior. Its @a aFloatingSignal argument must be consistent
  //! across threads.
  //!
  //! Keep in mind that whether the C++ exception will really be thrown (i.e.
  //! ::throw() will be called) is regulated by the NO_CXX_EXCEPTIONS and
  //! OCC_CONVERT_SIGNALS macros used during compilation of Open CASCADE and
  //! user's code. Refer to Foundation Classes User's Guide for further details.
  Standard_EXPORT static   void SetSignal (const Standard_Boolean theFloatingSignal = Standard_True) ;
  
  //! Returns available memory in Kilobytes.
  Standard_EXPORT static   Standard_Integer AvailableMemory() ;
  
  //! Commands the process to sleep for a number of seconds.
  Standard_EXPORT static   void SecSleep (const Standard_Integer aDelay) ;
  
  //! Commands the process to sleep for a number of milliseconds
  Standard_EXPORT static   void MilliSecSleep (const Standard_Integer aDelay) ;
  

  //! Converts aReal into aCstring in exponential format with a period as
  //! decimal point, no thousand separator and no grouping of digits.
  //! The conversion is independant from the current locale
  Standard_EXPORT static   Standard_Boolean RealToCString (const Standard_Real aReal, Standard_PCharacter& aString) ;
  

  //! Converts aCstring representing a real with a period as
  //! decimal point, no thousand separator and no grouping of digits
  //! into aReal .
  //! The conversion is independant from the current locale.
  Standard_EXPORT static   Standard_Boolean CStringToReal (const Standard_CString aString, Standard_Real& aReal) ;
  
  //! Tests if the quotient theDividend/theDivisor
  //! does not overflow
  Standard_EXPORT static   Standard_Boolean IsDivisible (const Standard_Real aDividend, const Standard_Real aDivisor) ;
  
  //! Returns the exponent in base 2 of a floating-point number.
  Standard_EXPORT static   Standard_Integer GetExponent (const Standard_Real aReal) ;
  
  //! Returns the mantissa of a floating-point number.
  Standard_EXPORT static   Standard_Real GetMantissa (const Standard_Real aReal) ;
  
  //! since Windows NT does not support 'SIGINT' signal like UNIX,
  //! then this method checks whether Ctrl-Break keystroke was or
  //! not. If yes then raises Exception_CTRL_BREAK.
  Standard_EXPORT static   void ControlBreak() ;




protected:





private:




friend class OSD_Error;
friend class OSD_Protection;
friend class OSD_Path;
friend class OSD_FileNode;
friend class OSD_Disk;
friend class OSD_File;
friend class OSD_FileIterator;
friend class OSD_Directory;
friend class OSD_DirectoryIterator;
friend class OSD_Chronometer;
friend class OSD_Timer;
friend class OSD_Printer;
friend class OSD_Host;
friend class OSD_Environment;
friend class OSD_EnvironmentIterator;
friend class OSD_Process;
friend class OSD_SharedLibrary;
friend class OSD_Thread;

};







#endif // _OSD_HeaderFile
