/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_vec2")
public class NkVec2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public NkVec2(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkVec2.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return NkVec2.nx(this.address());
    }

    public float y() {
        return NkVec2.ny(this.address());
    }

    public NkVec2 x(float value) {
        NkVec2.nx(this.address(), value);
        return this;
    }

    public NkVec2 y(float value) {
        NkVec2.ny(this.address(), value);
        return this;
    }

    public NkVec2 set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public NkVec2 set(NkVec2 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static NkVec2 malloc() {
        return (NkVec2)NkVec2.wrap(NkVec2.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkVec2 calloc() {
        return (NkVec2)NkVec2.wrap(NkVec2.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkVec2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkVec2)NkVec2.wrap(NkVec2.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkVec2 create(long address) {
        return (NkVec2)NkVec2.wrap(NkVec2.class, (long)address);
    }

    @Nullable
    public static NkVec2 createSafe(long address) {
        return address == 0L ? null : (NkVec2)NkVec2.wrap(NkVec2.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkVec2.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkVec2.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkVec2.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkVec2.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkVec2.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkVec2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkVec2.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static NkVec2 mallocStack() {
        return NkVec2.mallocStack(MemoryStack.stackGet());
    }

    public static NkVec2 callocStack() {
        return NkVec2.callocStack(MemoryStack.stackGet());
    }

    public static NkVec2 mallocStack(MemoryStack stack) {
        return (NkVec2)NkVec2.wrap(NkVec2.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkVec2 callocStack(MemoryStack stack) {
        return (NkVec2)NkVec2.wrap(NkVec2.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return NkVec2.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return NkVec2.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkVec2.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)NkVec2.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static float nx(long struct) {
        return UNSAFE.getFloat(null, struct + (long)X);
    }

    public static float ny(long struct) {
        return UNSAFE.getFloat(null, struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = NkVec2.__struct((Struct.Member[])new Struct.Member[]{NkVec2.__member((int)4), NkVec2.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkVec2, Buffer>
    implements NativeResource {
        private static final NkVec2 ELEMENT_FACTORY = NkVec2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkVec2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return NkVec2.nx(this.address());
        }

        public float y() {
            return NkVec2.ny(this.address());
        }

        public Buffer x(float value) {
            NkVec2.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            NkVec2.ny(this.address(), value);
            return this;
        }
    }
}

