/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.util.Collection;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class InfoWebAction
extends AbstractInfoAction {
    public InfoWebAction() {
        super(I18n.tr("Advanced info (web)", new Object[0]), "info", I18n.tr("Display object information about OSM nodes, ways, or relations in web browser.", new Object[0]), Shortcut.registerShortcut("core:infoweb", I18n.tr("Advanced info (web)", new Object[0]), 73, 5009), true, "action/infoweb", true);
        this.setHelpId(HelpUtil.ht("/Action/InfoAboutElementsWeb"));
    }

    @Override
    protected String createInfoUrl(Object infoObject) {
        if (infoObject instanceof IPrimitive) {
            IPrimitive primitive = (IPrimitive)infoObject;
            return Config.getUrls().getBaseBrowseUrl() + '/' + OsmPrimitiveType.from(primitive).getAPIName() + '/' + primitive.getOsmId();
        }
        if (infoObject instanceof Note) {
            Note note = (Note)infoObject;
            return Config.getUrls().getBaseBrowseUrl() + "/note/" + note.getId();
        }
        return null;
    }

    @Override
    protected void updateEnabledState() {
        super.updateEnabledState();
        this.updateEnabledStateWithNotes();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        super.updateEnabledState(selection);
        this.updateEnabledStateWithNotes();
    }

    private void updateEnabledStateWithNotes() {
        if (!this.isEnabled() && MainApplication.isDisplayingMapView() && MainApplication.getMap().noteDialog.getSelectedNote() != null) {
            this.setEnabled(true);
        }
    }

    public final void noteSelectionChanged() {
        this.updateEnabledState();
    }
}

