/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.beanproperty;

import javax.annotation.Nonnull;
import org.fest.reflect.beanproperty.PropertyAccessor;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.Preconditions;

public class PropertyTypeRef<T> {
    private final String propertyName;
    private final TypeRef<T> value;

    PropertyTypeRef(@Nonnull String propertyName, @Nonnull TypeRef<T> type) {
        this.propertyName = Preconditions.checkNotNullOrEmpty((String)propertyName);
        this.value = (TypeRef)Preconditions.checkNotNull(type);
    }

    @Nonnull
    public PropertyAccessor<T> in(@Nonnull Object target) {
        return new PropertyAccessor<T>(this.propertyName, this.value.rawType(), target);
    }
}

