/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scripting.gradle;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.scripting.gradle.GradleKotlinScriptConfigurationInputs;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.scripting.gradle.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u001a.\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r\u001a\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00010\u0003j\b\u0012\u0004\u0012\u00020\u0001`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"minimal_gradle_version_supported", "", "sections", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getGradleProjectSettings", "", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "getGradleScriptInputsStamp", "Lorg/jetbrains/kotlin/idea/scripting/gradle/GradleKotlinScriptConfigurationInputs;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "givenKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "givenTimeStamp", "", "isGradleKotlinScript", "", "virtualFile", "kotlinDslScriptsModelImportSupported", "currentGradleVersion", "kotlin.gradle.gradle-idea"})
public final class UtilsKt {
    private static final ArrayList<String> sections = CollectionsKt.arrayListOf((Object[])new String[]{"buildscript", "plugins", "initscript", "pluginManagement"});
    @NotNull
    public static final String minimal_gradle_version_supported = "6.0";

    public static final boolean isGradleKotlinScript(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String string = virtualFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.name");
        return StringsKt.endsWith$default((String)string, (String)".gradle.kts", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp(@NotNull Project project, @NotNull VirtualFile file, @Nullable KtFile givenKtFile, long givenTimeStamp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!UtilsKt.isGradleKotlinScript(file)) {
            return null;
        }
        return (GradleKotlinScriptConfigurationInputs)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<GradleKotlinScriptConfigurationInputs>(givenKtFile, project, file, givenTimeStamp){
            final /* synthetic */ KtFile $givenKtFile;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ long $givenTimeStamp;

            @Nullable
            public final GradleKotlinScriptConfigurationInputs invoke() {
                KtFile ktFile = this.$givenKtFile;
                if (ktFile == null) {
                    PsiFile psiFile = PsiManager.getInstance((Project)this.$project).findFile(this.$file);
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    ktFile = (KtFile)psiFile;
                }
                if (ktFile == null) {
                    return null;
                }
                KtFile ktFile2 = ktFile;
                StringBuilder result2 = new StringBuilder();
                KtScriptInitializer[] ktScriptInitializerArray = ktFile2.getScript();
                if (ktScriptInitializerArray != null && (ktScriptInitializerArray = ktScriptInitializerArray.getBlockExpression()) != null) {
                    PsiElement $this$getChildrenOfType$iv = (PsiElement)ktScriptInitializerArray;
                    boolean $i$f$getChildrenOfType = false;
                    PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtScriptInitializer.class);
                    if (psiElementArray == null) {
                        psiElementArray = new KtScriptInitializer[]{};
                    }
                    if ((ktScriptInitializerArray = (KtScriptInitializer[])psiElementArray) != null) {
                        KtScriptInitializer[] $this$forEach$iv = ktScriptInitializerArray;
                        boolean $i$f$forEach = false;
                        KtScriptInitializer[] ktScriptInitializerArray2 = $this$forEach$iv;
                        int n = ktScriptInitializerArray2.length;
                        for (int i = 0; i < n; ++i) {
                            KtLambdaArgument lambda2;
                            KtCallExpression call;
                            Object object;
                            KtScriptInitializer element$iv;
                            KtScriptInitializer it = element$iv = ktScriptInitializerArray2[i];
                            boolean bl = false;
                            Object[] objectArray = it.getChildren();
                            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"it.children");
                            Object object2 = ArraysKt.singleOrNull((Object[])objectArray);
                            if (!(object2 instanceof KtCallExpression)) {
                                object2 = null;
                            }
                            if ((object = (call = (KtCallExpression)object2)) == null || (object = object.getFirstChild()) == null || (object = object.getText()) == null) {
                                continue;
                            }
                            Object callRef = object;
                            if (!UtilsKt.access$getSections$p().contains(callRef)) continue;
                            result2.append((String)callRef);
                            List list = call.getLambdaArguments();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"call.lambdaArguments");
                            KtLambdaArgument ktLambdaArgument = lambda2 = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list);
                            if (ktLambdaArgument != null) {
                                ktLambdaArgument.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(false, result2){
                                    final /* synthetic */ StringBuilder $result$inlined;
                                    {
                                        this.$result$inlined = stringBuilder;
                                        super($super_call_param$1);
                                    }

                                    public void visitElement(@NotNull PsiElement element) {
                                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                        super.visitElement(element);
                                        PsiElement psiElement = element;
                                        if (psiElement instanceof PsiWhiteSpace) {
                                            String string = ((PsiWhiteSpace)element).getText();
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                                            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                                                this.$result$inlined.append("\n");
                                            }
                                        } else if (!(psiElement instanceof PsiComment) && psiElement instanceof LeafPsiElement) {
                                            this.$result$inlined.append(((LeafPsiElement)element).getText());
                                        }
                                    }
                                });
                            }
                            result2.append("\n");
                        }
                    }
                }
                GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot = GradleBuildRootsManager.Companion.getInstance(this.$project).findScriptBuildRoot(this.$file);
                GradleBuildRoot gradleBuildRoot = scriptUnderRoot != null ? scriptUnderRoot.getNearest() : null;
                if (!(gradleBuildRoot instanceof GradleBuildRoot)) {
                    gradleBuildRoot = null;
                }
                GradleBuildRoot buildRoot = gradleBuildRoot;
                String string = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
                GradleBuildRoot gradleBuildRoot2 = buildRoot;
                return new GradleKotlinScriptConfigurationInputs(string, this.$givenTimeStamp, gradleBuildRoot2 != null ? gradleBuildRoot2.getPathPrefix() : null);
            }
            {
                this.$givenKtFile = ktFile;
                this.$project = project;
                this.$file = virtualFile;
                this.$givenTimeStamp = l;
                super(0);
            }
        }));
    }

    public static /* synthetic */ GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp$default(Project project, VirtualFile virtualFile, KtFile ktFile, long l, int n, Object object) {
        if ((n & 4) != 0) {
            ktFile = null;
        }
        if ((n & 8) != 0) {
            l = virtualFile.getModificationStamp();
        }
        return UtilsKt.getGradleScriptInputsStamp(project, virtualFile, ktFile, l);
    }

    public static final boolean kotlinDslScriptsModelImportSupported(@NotNull String currentGradleVersion) {
        Intrinsics.checkNotNullParameter((Object)currentGradleVersion, (String)"currentGradleVersion");
        return GradleVersion.version((String)currentGradleVersion).compareTo(GradleVersion.version((String)minimal_gradle_version_supported)) >= 0;
    }

    @NotNull
    public static final Collection<GradleProjectSettings> getGradleProjectSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (abstractExternalSystemSettings == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.plugins.gradle.settings.GradleSettings");
        }
        Collection collection = ((GradleSettings)abstractExternalSystemSettings).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"(ExternalSystemApiUtil.g\u2026s).linkedProjectsSettings");
        return collection;
    }

    public static final /* synthetic */ ArrayList access$getSections$p() {
        return sections;
    }
}

