/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.BrowserHyperlinkListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J%\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ShowKotlinGradleDslLogs;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findLogsDir", "Ljava/io/File;", "getFamilyName", "", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "openLogsDirIfPresent", "startInWriteAction", "update", "Companion", "kotlin.gradle.gradle-idea"})
public final class ShowKotlinGradleDslLogs
extends AnAction
implements IntentionAction,
DumbAware {
    private static final String gradleTroubleshootingLink = "https://docs.gradle.org/current/userguide/kotlin_dsl.html#troubleshooting";
    @NotNull
    private static final String NAME;
    public static final Companion Companion;

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.openLogsDirIfPresent(project);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        this.openLogsDirIfPresent(project2);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RevealFileAction.isSupported();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        Presentation presentation2 = presentation;
        presentation2.setEnabledAndVisible(e.getProject() != null && RevealFileAction.isSupported());
        presentation2.setText(NAME);
    }

    private final void openLogsDirIfPresent(Project project) {
        File logsDir = this.findLogsDir();
        if (logsDir != null) {
            RevealFileAction.openDirectory((File)logsDir);
        } else {
            Object object = WindowManager.getInstance().getStatusBar(project);
            if (object == null || (object = object.getComponent()) == null) {
                JFrame jFrame = WindowManager.getInstance().findVisibleFrame();
                object = jFrame != null ? jFrame.getRootPane() : null;
            }
            Object parent = object;
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(KotlinIdeaGradleBundle.message("text.gradle.dsl.logs.cannot.be.found.automatically.see.how.to.find.logs", gradleTroubleshootingLink), MessageType.ERROR, (HyperlinkListener)BrowserHyperlinkListener.INSTANCE).setFadeoutTime(5000L).createBalloon().showInCenterOf((JComponent)parent);
        }
    }

    private final File findLogsDir() {
        String userHome = System.getProperty("user.home");
        File file = SystemInfo.isMac ? new File(userHome + "/Library/Logs/gradle-kotlin-dsl") : (SystemInfo.isLinux ? new File(userHome + "/.gradle-kotlin-dsl/logs") : (SystemInfo.isWindows ? new File(userHome + "/AppData/Local/gradle-kotlin-dsl/log") : null));
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        File file2 = it;
        return file2 != null && file2.exists() ? file : null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        return NAME;
    }

    @NotNull
    public String getFamilyName() {
        return NAME;
    }

    static {
        Companion = new Companion(null);
        Object[] objectArray = new Object[1];
        String string = RevealFileAction.getFileManagerName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RevealFileAction.getFileManagerName()");
        objectArray[0] = string;
        NAME = KotlinIdeaGradleBundle.message("action.text.show.kotlin.gradle.dsl.logs.in", objectArray);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/actions/ShowKotlinGradleDslLogs$Companion;", "", "()V", "NAME", "", "getNAME", "()Ljava/lang/String;", "gradleTroubleshootingLink", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        @NotNull
        public final String getNAME() {
            return NAME;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

