/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class GradleFileModelImpl
implements GradleFileModel {
    @NotNull
    protected GradleDslFile myGradleDslFile;

    public GradleFileModelImpl(@NotNull GradleDslFile gradleDslFile) {
        if (gradleDslFile == null) {
            GradleFileModelImpl.$$$reportNull$$$0(0);
        }
        this.myGradleDslFile = gradleDslFile;
    }

    @Nullable
    public PsiElement getPsiElement() {
        return this.myGradleDslFile.getPsiElement();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myGradleDslFile.getProject();
        if (project == null) {
            GradleFileModelImpl.$$$reportNull$$$0(1);
        }
        return project;
    }

    public void reparse() {
        this.myGradleDslFile.reparse();
    }

    public boolean isModified() {
        return this.myGradleDslFile.isModified();
    }

    public void resetState() {
        this.myGradleDslFile.resetState();
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myGradleDslFile.getFile();
        if (virtualFile == null) {
            GradleFileModelImpl.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @NotNull
    public Map<String, GradlePropertyModel> getInScopeProperties() {
        Map<String, GradlePropertyModel> map = this.myGradleDslFile.getInScopeElements().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new GradlePropertyModelImpl((GradleDslElement)e.getValue())));
        if (map == null) {
            GradleFileModelImpl.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public List<GradlePropertyModel> getDeclaredProperties() {
        List<GradlePropertyModel> list = this.myGradleDslFile.getContainedElements(false).stream().map(e -> new GradlePropertyModelImpl((GradleDslElement)e)).collect(Collectors.toList());
        if (list == null) {
            GradleFileModelImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public Set<GradleDslFile> getAllInvolvedFiles() {
        HashSet<GradleDslFile> files = new HashSet<GradleDslFile>();
        files.add(this.myGradleDslFile);
        files.addAll(this.getParentFiles());
        ArrayList<GradleDslFile> currentFiles = new ArrayList<GradleDslFile>();
        currentFiles.add(this.myGradleDslFile);
        while (!currentFiles.isEmpty()) {
            GradleDslFile currentFile = (GradleDslFile)currentFiles.remove(0);
            files.addAll(currentFile.getApplyDslElement());
            currentFiles.addAll(currentFile.getApplyDslElement());
        }
        for (GradleDslFile file : new ArrayList(files)) {
            GradleDslFile sibling = file.getSiblingDslFile();
            if (sibling == null) continue;
            files.add(sibling);
        }
        HashSet<GradleDslFile> hashSet = files;
        if (hashSet == null) {
            GradleFileModelImpl.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private Set<GradleDslFile> getParentFiles() {
        HashSet<GradleDslFile> files = new HashSet<GradleDslFile>();
        for (GradleDslFile file = this.myGradleDslFile.getParentModuleDslFile(); file != null; file = file.getParentModuleDslFile()) {
            files.add(file);
        }
        return files;
    }

    private void saveAllRelatedFiles() {
        this.getAllInvolvedFiles().forEach(GradleDslFile::saveAllChanges);
    }

    public void applyChanges() {
        this.myGradleDslFile.applyChanges();
        this.saveAllRelatedFiles();
    }

    @TestOnly
    @NotNull
    public GradleDslFile getDslFile() {
        GradleDslFile gradleDslFile = this.myGradleDslFile;
        if (gradleDslFile == null) {
            GradleFileModelImpl.$$$reportNull$$$0(6);
        }
        return gradleDslFile;
    }

    @NotNull
    public Map<String, List<BuildModelNotification>> getNotifications() {
        Map<String, List<BuildModelNotification>> map = this.getAllInvolvedFiles().stream().filter(e -> !e.getPublicNotifications().isEmpty()).collect(Collectors.toMap(e -> e.getFile().getPath(), e -> e.getPublicNotifications()));
        if (map == null) {
            GradleFileModelImpl.$$$reportNull$$$0(7);
        }
        return map;
    }

    @Nullable
    public PsiFile getPsiFile() {
        PsiElement element = this.myGradleDslFile.getPsiElement();
        return element instanceof PsiFile ? (PsiFile)element : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleDslFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleFileModelImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleFileModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInScopeProperties";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredProperties";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllInvolvedFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDslFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

