/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.GradleUtil;
import com.android.tools.idea.gradle.dsl.api.BuildScriptModel;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleFileModel;
import com.android.tools.idea.gradle.dsl.api.PluginModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.configurations.ConfigurationsModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.ExtModel;
import com.android.tools.idea.gradle.dsl.api.ext.PropertyType;
import com.android.tools.idea.gradle.dsl.api.java.JavaModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.dsl.api.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradlePropertiesModel;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.PluginModelImpl;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModelImpl;
import com.android.tools.idea.gradle.dsl.model.build.BuildScriptModelImpl;
import com.android.tools.idea.gradle.dsl.model.configurations.ConfigurationsModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.ExtModelImpl;
import com.android.tools.idea.gradle.dsl.model.java.JavaModelImpl;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.BuildScriptDslElement;
import com.android.tools.idea.gradle.dsl.parser.build.SubProjectsDslElement;
import com.android.tools.idea.gradle.dsl.parser.configurations.ConfigurationsDslElement;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.ext.ExtDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.java.JavaDslElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GradleBuildModelImpl
extends GradleFileModelImpl
implements GradleBuildModel {
    @NonNls
    private static final String PLUGIN = "plugin";
    @NonNls
    private static final String ID = "id";

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Project project) {
        VirtualFile file;
        if (project == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(0);
        }
        return (file = GradleUtil.getGradleBuildFile(GradleUtil.getBaseDirPath(project))) != null ? GradleBuildModelImpl.parseBuildFile(file, project, project.getName()) : null;
    }

    @Deprecated
    @Nullable
    public static GradleBuildModel get(@NotNull Module module) {
        VirtualFile file;
        if (module == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(1);
        }
        return (file = GradleUtil.getGradleBuildFile(module)) != null ? GradleBuildModelImpl.parseBuildFile(file, module.getProject(), module.getName()) : null;
    }

    @Deprecated
    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(3);
        }
        return GradleBuildModelImpl.parseBuildFile(file, project, "<Unknown>");
    }

    @Deprecated
    @NotNull
    public static GradleBuildModel parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(5);
        }
        if (moduleName == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(6);
        }
        return new GradleBuildModelImpl(BuildModelContext.create(project).getOrCreateBuildFile(file, moduleName, false));
    }

    @Deprecated
    @NotNull
    public List<GradleNotNullValue<String>> appliedPlugins() {
        List<GradleNotNullValue<String>> list = this.plugins().stream().map(plugin -> new GradleNotNullValue<String>(){

            @NotNull
            public VirtualFile getFile() {
                VirtualFile virtualFile = plugin.name().getGradleFile();
                if (virtualFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                return virtualFile;
            }

            @NotNull
            public String getPropertyName() {
                String string = plugin.name().getName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public String getDslText() {
                return (String)ApplicationManager.getApplication().runReadAction(() -> {
                    PsiElement e = plugin.name().getPsiElement();
                    return e == null ? null : e.getText();
                });
            }

            @NotNull
            public Map<String, GradleNotNullValue<Object>> getResolvedVariables() {
                ImmutableMap immutableMap = ImmutableMap.of();
                if (immutableMap == null) {
                    1.$$$reportNull$$$0(2);
                }
                return immutableMap;
            }

            @NotNull
            public String value() {
                String string = plugin.name().forceString();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Nullable
            public PsiElement getPsiElement() {
                return plugin.name().getPsiElement();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPropertyName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getResolvedVariables";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "value";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }).collect(Collectors.toList());
        if (list == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static GradleBuildFile parseBuildFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context, boolean isApplied) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(9);
        }
        if (moduleName == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(11);
        }
        GradleBuildFile buildDslFile = new GradleBuildFile(file, project, moduleName, context);
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!isApplied) {
                GradleBuildModelImpl.populateWithParentModuleSubProjectsProperties(buildDslFile, context);
            }
            GradleBuildModelImpl.populateSiblingDslFileWithGradlePropertiesFile(buildDslFile, context);
            buildDslFile.parse();
        });
        GradleBuildFile gradleBuildFile = buildDslFile;
        if (gradleBuildFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(12);
        }
        return gradleBuildFile;
    }

    public static void populateWithParentModuleSubProjectsProperties(@NotNull GradleBuildFile buildDslFile, @NotNull BuildModelContext context) {
        VirtualFile maybeSettingsFile;
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(13);
        }
        if (context == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(14);
        }
        if ((maybeSettingsFile = buildDslFile.tryToFindSettingsFile()) == null) {
            return;
        }
        GradleSettingsFile settingsFile = context.getOrCreateSettingsFile(maybeSettingsFile);
        GradleSettingsModelImpl gradleSettingsModel = new GradleSettingsModelImpl(settingsFile);
        String modulePath = gradleSettingsModel.moduleWithDirectory(buildDslFile.getDirectoryPath());
        if (modulePath == null) {
            return;
        }
        GradleBuildModel parentModuleModel = gradleSettingsModel.getParentModuleModel(modulePath);
        if (!(parentModuleModel instanceof GradleBuildModelImpl)) {
            return;
        }
        GradleBuildModelImpl parentModuleModelImpl = (GradleBuildModelImpl)parentModuleModel;
        GradleDslFile parentModuleDslFile = parentModuleModelImpl.myGradleDslFile;
        buildDslFile.setParentModuleDslFile(parentModuleDslFile);
        SubProjectsDslElement subProjectsDslElement = parentModuleDslFile.getPropertyElement(SubProjectsDslElement.SUBPROJECTS);
        if (subProjectsDslElement == null) {
            return;
        }
        buildDslFile.setParsedElement(subProjectsDslElement);
        for (Map.Entry<String, GradleDslElement> entry : subProjectsDslElement.getPropertyElements().entrySet()) {
            GradleDslElement element = entry.getValue();
            if (element instanceof ApplyDslElement) {
                ApplyDslElement subProjectsApply = (ApplyDslElement)element;
                ApplyDslElement myApply = new ApplyDslElement(buildDslFile);
                buildDslFile.setParsedElement(myApply);
                for (GradleDslElement appliedElement : subProjectsApply.getAllElements()) {
                    myApply.addParsedElement(appliedElement);
                }
                continue;
            }
            buildDslFile.setParsedElement(element);
        }
    }

    public static void populateSiblingDslFileWithGradlePropertiesFile(@NotNull GradleBuildFile buildDslFile, @NotNull BuildModelContext context) {
        File propertiesFilePath;
        VirtualFile propertiesFile;
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(16);
        }
        if ((propertiesFile = VfsUtil.findFileByIoFile((File)(propertiesFilePath = new File(buildDslFile.getDirectoryPath(), "gradle.properties")), (boolean)false)) == null) {
            return;
        }
        GradlePropertiesFile parsedProperties = context.getOrCreatePropertiesFile(propertiesFile, buildDslFile.getName());
        if (parsedProperties == null) {
            return;
        }
        GradlePropertiesModel propertiesModel = new GradlePropertiesModel(parsedProperties);
        GradleDslFile propertiesDslFile = propertiesModel.myGradleDslFile;
        buildDslFile.setSiblingDslFile(propertiesDslFile);
        propertiesDslFile.setSiblingDslFile(buildDslFile);
    }

    GradleBuildModelImpl(@NotNull GradleBuildFile buildDslFile) {
        if (buildDslFile == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(17);
        }
        super(buildDslFile);
    }

    @NotNull
    public List<PluginModel> plugins() {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ArrayList<PluginModelImpl> plugins = new ArrayList<PluginModelImpl>();
        if (pluginsDslElement != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement)).values());
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class)) != null) {
            plugins.addAll(PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement)).values());
        }
        return new ArrayList<PluginModel>(PluginModelImpl.deduplicatePlugins(plugins).values());
    }

    @NotNull
    public PluginModel applyPlugin(@NotNull String plugin) {
        Map<String, PluginModelImpl> applyPluginsModels;
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(18);
        }
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS);
        ApplyDslElement applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class);
        if (pluginsDslElement == null && applyDslElement == null) {
            pluginsDslElement = new PluginsDslElement(this.myGradleDslFile, GradleNameElement.fake(PluginsDslElement.PLUGINS.name));
            this.myGradleDslFile.addNewElementAt(0, pluginsDslElement);
        } else if (pluginsDslElement == null) {
            Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement));
            if (models.containsKey(plugin)) {
                PluginModel pluginModel = models.get(plugin);
                if (pluginModel == null) {
                    GradleBuildModelImpl.$$$reportNull$$$0(19);
                }
                return pluginModel;
            }
            GradleDslExpressionMap applyMap = new GradleDslExpressionMap(this.myGradleDslFile, GradleNameElement.create("apply"));
            applyMap.setAsNamedArgs(true);
            GradleDslLiteral literal = new GradleDslLiteral(applyMap, GradleNameElement.create(PLUGIN));
            literal.setValue(plugin.trim());
            applyMap.setNewElement(literal);
            applyDslElement.setNewElement(applyMap);
            return new PluginModelImpl(applyMap, literal);
        }
        Map<String, PluginModelImpl> models = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(pluginsDslElement));
        if (models.containsKey(plugin)) {
            PluginModel pluginModel = models.get(plugin);
            if (pluginModel == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(20);
            }
            return pluginModel;
        }
        if (applyDslElement != null && (applyPluginsModels = PluginModelImpl.deduplicatePlugins(PluginModelImpl.create(applyDslElement))).containsKey(plugin)) {
            PluginModel pluginModel = applyPluginsModels.get(plugin);
            if (pluginModel == null) {
                GradleBuildModelImpl.$$$reportNull$$$0(21);
            }
            return pluginModel;
        }
        GradleDslLiteral literal = new GradleDslLiteral(pluginsDslElement, GradleNameElement.create(ID));
        literal.setElementType(PropertyType.REGULAR);
        literal.setValue(plugin.trim());
        pluginsDslElement.setNewElement(literal);
        return new PluginModelImpl(literal, literal);
    }

    public void removePlugin(@NotNull String plugin) {
        ApplyDslElement applyDslElement;
        PluginsDslElement pluginsDslElement;
        if (plugin == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(22);
        }
        if ((pluginsDslElement = this.myGradleDslFile.getPropertyElement(PluginsDslElement.PLUGINS)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(pluginsDslElement), plugin);
        }
        if ((applyDslElement = this.myGradleDslFile.getPropertyElement("apply", ApplyDslElement.class)) != null) {
            PluginModelImpl.removePlugins(PluginModelImpl.create(applyDslElement), plugin);
        }
    }

    @NotNull
    public AndroidModel android() {
        AndroidDslElement androidDslElement = this.myGradleDslFile.ensurePropertyElement(AndroidDslElement.ANDROID);
        return new AndroidModelImpl(androidDslElement);
    }

    @NotNull
    public BuildScriptModel buildscript() {
        BuildScriptDslElement buildScriptDslElement = this.myGradleDslFile.ensurePropertyElement(BuildScriptDslElement.BUILDSCRIPT);
        return new BuildScriptModelImpl(buildScriptDslElement);
    }

    @NotNull
    public ConfigurationsModel configurations() {
        ConfigurationsDslElement configurationsDslElement = this.myGradleDslFile.ensurePropertyElementBefore(ConfigurationsDslElement.CONFIGURATIONS, DependenciesDslElement.class);
        return new ConfigurationsModelImpl(configurationsDslElement);
    }

    @NotNull
    public DependenciesModel dependencies() {
        DependenciesDslElement dependenciesDslElement = this.myGradleDslFile.ensurePropertyElement(DependenciesDslElement.DEPENDENCIES);
        return new DependenciesModelImpl(dependenciesDslElement);
    }

    @NotNull
    public ExtModel ext() {
        int at = 0;
        List<GradleDslElement> elements = this.myGradleDslFile.getAllElements();
        if (!elements.isEmpty() && elements.get(0) instanceof ApplyDslElement) {
            ++at;
        }
        ExtDslElement extDslElement = this.myGradleDslFile.ensurePropertyElementAt(ExtDslElement.EXT, at);
        return new ExtModelImpl(extDslElement);
    }

    @NotNull
    public JavaModel java() {
        JavaDslElement javaDslElement = this.myGradleDslFile.ensurePropertyElement(JavaDslElement.JAVA);
        return new JavaModelImpl(javaDslElement);
    }

    @NotNull
    public RepositoriesModel repositories() {
        RepositoriesDslElement repositoriesDslElement = this.myGradleDslFile.ensurePropertyElement(RepositoriesDslElement.REPOSITORIES);
        return new RepositoriesModelImpl(repositoriesDslElement);
    }

    @NotNull
    public Set<GradleFileModel> getInvolvedFiles() {
        Set<GradleFileModel> set = this.getAllInvolvedFiles().stream().distinct().map(e -> GradleBuildModelImpl.getFileModel(e)).collect(Collectors.toSet());
        if (set == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(23);
        }
        return set;
    }

    @NotNull
    private static GradleFileModel getFileModel(@NotNull GradleDslFile file) {
        if (file == null) {
            GradleBuildModelImpl.$$$reportNull$$$0(24);
        }
        if (file instanceof GradleBuildFile) {
            return new GradleBuildModelImpl((GradleBuildFile)file);
        }
        if (file instanceof GradleSettingsFile) {
            return new GradleSettingsModelImpl((GradleSettingsFile)file);
        }
        if (file instanceof GradlePropertiesFile) {
            return new GradlePropertiesModel(file);
        }
        throw new IllegalStateException("Unknown GradleDslFile type found!");
    }

    @TestOnly
    public void removeRepositoriesBlocks() {
        this.myGradleDslFile.removeProperty(RepositoriesDslElement.REPOSITORIES.name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDslFile";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = PLUGIN;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleBuildModelImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "appliedPlugins";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBuildFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPlugin";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvolvedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseBuildFile";
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "populateWithParentModuleSubProjectsProperties";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "populateSiblingDslFileWithGradlePropertiesFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "applyPlugin";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removePlugin";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFileModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

