/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.signaturer;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrSignatureComposer;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.signaturer.FirMangler;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSignatureComposer;", "mangler", "Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirMangler;)V", "relativeCallableName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "getRelativeCallableName", "(Lorg/jetbrains/kotlin/fir/symbols/CallableId;)Lorg/jetbrains/kotlin/name/FqName;", "composeAccessorSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "isSetter", "", "composeSignature", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "SignatureBuilder", "fir2ir"})
public final class FirBasedSignatureComposer
implements Fir2IrSignatureComposer {
    private final FirMangler mangler;

    private final FqName getRelativeCallableName(CallableId $this$relativeCallableName) {
        FqName fqName2 = $this$relativeCallableName.getClassName();
        if (fqName2 == null || (fqName2 = fqName2.child($this$relativeCallableName.getCallableName())) == null) {
            FqName fqName3 = FqName.topLevel($this$relativeCallableName.getCallableName());
            fqName2 = fqName3;
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"FqName.topLevel(callableName)");
        }
        return fqName2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IdSignature composeSignature(@NotNull FirDeclaration declaration) {
        IdSignature.PublicSignature publicSignature;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        SignatureBuilder builder = new SignatureBuilder();
        declaration.accept(builder);
        if (declaration instanceof FirRegularClass) {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.LOCAL) ^ true) {
                ClassId classId = FirDeclarationUtilKt.getClassId((FirClass)declaration);
                FqName fqName2 = classId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
                FqName fqName3 = classId.getRelativeClassName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"classId.relativeClassName");
                publicSignature = new IdSignature.PublicSignature(fqName2, fqName3, builder.getHashId(), builder.getMask());
                return publicSignature;
            }
        }
        if (!(declaration instanceof FirCallableMemberDeclaration)) throw (Throwable)((Object)new AssertionError((Object)("Unsupported FIR declaration in signature composer: " + FirRendererKt.render$default(declaration, null, 1, null))));
        CallableId callableId = ((FirCallableMemberDeclaration)declaration).getSymbol().getCallableId();
        publicSignature = new IdSignature.PublicSignature(callableId.getPackageName(), this.getRelativeCallableName(callableId), builder.getHashId(), builder.getMask());
        return publicSignature;
    }

    @Override
    @NotNull
    public IdSignature composeAccessorSignature(@NotNull FirProperty property2, boolean isSetter) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        IdSignature idSignature = this.composeSignature(property2);
        if (idSignature == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.util.IdSignature.PublicSignature");
        }
        IdSignature.PublicSignature propertySignature = (IdSignature.PublicSignature)idSignature;
        FqName fqName2 = isSetter ? propertySignature.getDeclarationFqn().child(Name.special("<set-" + property2.getName() + '>')) : propertySignature.getDeclarationFqn().child(Name.special("<get-" + property2.getName() + '>'));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"if (isSetter) {\n        \u2026perty.name}>\"))\n        }");
        FqName accessorFqName = fqName2;
        return new IdSignature.PublicSignature(propertySignature.getPackageFqn(), accessorFqName, propertySignature.getId(), propertySignature.getMask());
    }

    public FirBasedSignatureComposer(@NotNull FirMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.mangler = mangler;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer$SignatureBuilder;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "(Lorg/jetbrains/kotlin/fir/signaturer/FirBasedSignatureComposer;)V", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "mask", "getMask", "()J", "setMask", "(J)V", "setExpected", "", "f", "", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "fir2ir"})
    public final class SignatureBuilder
    extends FirVisitorVoid {
        @Nullable
        private Long hashId;
        private long mask;

        @Nullable
        public final Long getHashId() {
            return this.hashId;
        }

        public final void setHashId(@Nullable Long l) {
            this.hashId = l;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        private final void setExpected(boolean f) {
            this.mask |= IdSignature.Flags.IS_EXPECT.encode(f);
        }

        @Override
        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string2 = "Should not be here";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            FirMemberDeclaration $this$isExpect$iv = regularClass;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitConstructor(@NotNull FirConstructor constructor) {
            void $this$run;
            Long l;
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            signatureBuilder.hashId = l = Long.valueOf($this$run.getSignatureMangle((FirDeclaration)constructor));
            FirMemberDeclaration $this$isExpect$iv = constructor;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction) {
            void $this$run;
            Long l;
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            signatureBuilder.hashId = l = Long.valueOf($this$run.getSignatureMangle((FirDeclaration)simpleFunction));
            FirMemberDeclaration $this$isExpect$iv = simpleFunction;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitProperty(@NotNull FirProperty property2) {
            void $this$run;
            Long l;
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            FirMangler firMangler = FirBasedSignatureComposer.this.mangler;
            boolean bl = false;
            boolean bl2 = false;
            FirMangler firMangler2 = firMangler;
            SignatureBuilder signatureBuilder = this;
            boolean bl3 = false;
            signatureBuilder.hashId = l = Long.valueOf($this$run.getSignatureMangle((FirDeclaration)property2));
            FirMemberDeclaration $this$isExpect$iv = property2;
            boolean $i$f$isExpect = false;
            this.setExpected($this$isExpect$iv.getStatus().isExpect());
        }
    }
}

