/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.dom.AntDomCustomElement;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomNamedElement;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.lang.ant.dom.AntDomTypeDef;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.util.List;
import org.jetbrains.annotations.Nls;

public class AntAnnotator
implements DomElementsAnnotator {
    public void annotate(DomElement element, final DomElementAnnotationHolder holder) {
        element.accept((DomElementVisitor)new AntDomRecursiveVisitor(){

            @Override
            public void visitTypeDef(AntDomTypeDef typedef) {
                List<String> errors = typedef.getErrorDescriptions();
                if (!errors.isEmpty()) {
                    @Nls StringBuilder builder = new StringBuilder();
                    builder.append(AntBundle.message("failed.to.load.types", new Object[0])).append(":");
                    for (String error : errors) {
                        builder.append("\n").append(error);
                    }
                    AntAnnotator.createAnnotationOnTag(typedef, builder.toString(), holder);
                }
                super.visitTypeDef(typedef);
            }

            @Override
            public void visitAntDomCustomElement(AntDomCustomElement custom) {
                AntDomNamedElement declaringElement;
                if (custom.getDefinitionClass() == null && (declaringElement = custom.getDeclaringElement()) instanceof AntDomTypeDef) {
                    Object failedMessage = AntBundle.message("using.definition.which.type.failed.to.load", new Object[0]);
                    String error = custom.getLoadError();
                    if (error != null) {
                        failedMessage = (String)failedMessage + ": " + error;
                    }
                    AntAnnotator.createAnnotationOnTag(custom, (String)failedMessage, holder);
                }
                super.visitAntDomCustomElement(custom);
            }
        });
    }

    private static void createAnnotationOnTag(AntDomElement custom, @InspectionMessage String failedMessage, DomElementAnnotationHolder holder) {
        XmlTag tag = custom.getXmlTag();
        if (tag == null) {
            return;
        }
        String name = custom.getXmlElementName();
        TextRange absoluteRange = new TextRange(0, name.length()).shiftRight(tag.getTextRange().getStartOffset() + 1);
        holder.createProblem((DomElement)custom, failedMessage, new LocalQuickFix[0]);
    }
}

