/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.lang.UrlClassLoader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class AntResourcesClassLoader
extends UrlClassLoader {
    private final Set<String> myMisses = new HashSet<String>();

    public AntResourcesClassLoader(List<URL> urls, ClassLoader parentLoader, boolean canLockJars, boolean canUseCache) {
        super(AntResourcesClassLoader.build().urls(urls).parent(parentLoader).allowLock(canLockJars).useCache(canUseCache).noPreload());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            if (this.myMisses.contains(name)) {
                throw new ClassNotFoundException(name){

                    @Override
                    public synchronized Throwable fillInStackTrace() {
                        return this;
                    }
                };
            }
            return super.loadClass(name, resolve);
        }
    }

    protected Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        if (name == null) {
            AntResourcesClassLoader.$$$reportNull$$$0(0);
        }
        ProgressManager.checkCanceled();
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            this.myMisses.add(name);
            throw e;
        }
    }

    static {
        if (AntResourcesClassLoader.registerAsParallelCapable()) {
            AntResourcesClassLoader.markParallelCapable(AntResourcesClassLoader.class);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/ant/config/impl/AntResourcesClassLoader", "findClass"));
    }
}

