/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.execution.BeforeRunTask;
import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.impl.AntBeforeRunTaskProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class AntBeforeRunTask
extends BeforeRunTask<AntBeforeRunTask> {
    private final Project project;
    private String myTargetName;
    private String myAntFileUrl;

    public AntBeforeRunTask(@NotNull Project project) {
        if (project == null) {
            AntBeforeRunTask.$$$reportNull$$$0(0);
        }
        super(AntBeforeRunTaskProvider.ID);
        this.project = project;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            AntBeforeRunTask.$$$reportNull$$$0(1);
        }
        return project;
    }

    @NlsSafe
    public String getAntFileUrl() {
        return this.myAntFileUrl;
    }

    public void setAntFileUrl(String url) {
        this.myAntFileUrl = url;
    }

    @NlsSafe
    public String getTargetName() {
        return this.myTargetName;
    }

    public void setTargetName(String targetName) {
        this.myTargetName = targetName;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            AntBeforeRunTask.$$$reportNull$$$0(2);
        }
        super.writeExternal(element);
        if (this.myAntFileUrl != null && this.myTargetName != null) {
            element.setAttribute("antfile", this.myAntFileUrl);
            element.setAttribute("target", this.myTargetName);
        }
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            AntBeforeRunTask.$$$reportNull$$$0(3);
        }
        super.readExternal(element);
        String url = element.getAttributeValue("antfile");
        String targetName = element.getAttributeValue("target");
        if (url != null && targetName != null) {
            this.myAntFileUrl = url;
            this.myTargetName = targetName;
        }
    }

    public boolean isRunningTarget(AntBuildTarget target) {
        VirtualFile vFile = target.getModel().getBuildFile().getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (this.myAntFileUrl == null || !VfsUtilCore.pathEqualsTo((VirtualFile)vFile, (String)VfsUtilCore.urlToPath((String)this.myAntFileUrl))) {
            return false;
        }
        return Objects.equals(this.myTargetName, target.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AntBeforeRunTask that = (AntBeforeRunTask)((Object)o);
        if (this.myAntFileUrl != null ? !this.myAntFileUrl.equals(that.myAntFileUrl) : that.myAntFileUrl != null) {
            return false;
        }
        return !(this.myTargetName != null ? !this.myTargetName.equals(that.myTargetName) : that.myTargetName != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.myTargetName != null ? this.myTargetName.hashCode() : 0);
        result = 31 * result + (this.myAntFileUrl != null ? this.myAntFileUrl.hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/config/impl/AntBeforeRunTask";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/config/impl/AntBeforeRunTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

