/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.Stack;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;

public class YAMLParser
implements PsiParser,
YAMLTokenTypes {
    public static final TokenSet HASH_STOP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RBRACE, COMMA});
    public static final TokenSet ARRAY_STOP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RBRACKET, COMMA});
    private PsiBuilder myBuilder;
    private boolean eolSeen = false;
    private int myIndent;
    private PsiBuilder.Marker myAfterLastEolMarker;
    private final Stack<TokenSet> myStopTokensStack = new Stack();

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            YAMLParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            YAMLParser.$$$reportNull$$$0(1);
        }
        this.myBuilder = builder;
        this.myStopTokensStack.clear();
        PsiBuilder.Marker fileMarker = this.mark();
        this.parseFile();
        assert (this.myBuilder.eof()) : "Not all tokens were passed.";
        fileMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            YAMLParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    private void parseFile() {
        PsiBuilder.Marker marker = this.mark();
        this.passJunk();
        if (this.myBuilder.getTokenType() != DOCUMENT_MARKER) {
            this.dropEolMarker();
            marker.rollbackTo();
        } else {
            marker.drop();
        }
        do {
            this.parseDocument();
            this.passJunk();
        } while (!this.myBuilder.eof());
        this.dropEolMarker();
    }

    private void parseDocument() {
        PsiBuilder.Marker marker = this.mark();
        if (this.myBuilder.getTokenType() == DOCUMENT_MARKER) {
            this.advanceLexer();
        }
        this.parseBlockNode(this.myIndent, false);
        this.dropEolMarker();
        marker.done((IElementType)YAMLElementTypes.DOCUMENT);
    }

    private void parseBlockNode(int indent, boolean insideSequence) {
        if (this.getTokenType() == EOL) {
            this.advanceLexer();
            if (this.getTokenType() == INDENT) {
                this.advanceLexer();
            }
        }
        PsiBuilder.Marker marker = this.mark();
        this.passJunk();
        PsiBuilder.Marker endOfNodeMarker = null;
        YAMLElementType nodeType = null;
        if (this.getTokenType() == YAMLTokenTypes.TAG && this.myBuilder.lookAhead(1) == YAMLTokenTypes.EOL) {
            this.advanceLexer();
        }
        int numberOfItems = 0;
        while (!(this.eof() || !this.isJunk() && this.eolSeen && this.myIndent + this.getIndentBonus(insideSequence) < indent)) {
            if (this.isJunk()) {
                this.advanceLexer();
                continue;
            }
            if (!this.myStopTokensStack.isEmpty() && ((TokenSet)this.myStopTokensStack.peek()).contains(this.getTokenType())) {
                this.rollBackToEol();
                break;
            }
            ++numberOfItems;
            IElementType parsedTokenType = this.parseSingleStatement(this.eolSeen ? this.myIndent : indent, indent);
            if (nodeType == null) {
                if (parsedTokenType == YAMLElementTypes.SEQUENCE_ITEM) {
                    nodeType = YAMLElementTypes.SEQUENCE;
                } else if (parsedTokenType == YAMLElementTypes.KEY_VALUE_PAIR) {
                    nodeType = YAMLElementTypes.MAPPING;
                } else if (numberOfItems > 1) {
                    nodeType = YAMLElementTypes.COMPOUND_VALUE;
                }
            }
            if (endOfNodeMarker != null) {
                endOfNodeMarker.drop();
            }
            endOfNodeMarker = this.mark();
        }
        if (endOfNodeMarker != null) {
            this.dropEolMarker();
            endOfNodeMarker.rollbackTo();
        } else {
            this.rollBackToEol();
        }
        this.includeBlockEmptyTail(indent);
        if (nodeType != null) {
            marker.done(nodeType);
            marker.setCustomEdgeTokenBinders((tokens, atStreamEdge, getter) -> YAMLParser.findLeftRange(tokens), (tokens, atStreamEdge, getter) -> tokens.size());
        } else {
            marker.drop();
        }
    }

    private void includeBlockEmptyTail(int indent) {
        if (indent == 0) {
            while (this.isJunk() && (this.getTokenType() != EOL || YAMLElementTypes.BLANK_ELEMENTS.contains(this.myBuilder.lookAhead(1)))) {
                this.advanceLexer();
                this.dropEolMarker();
            }
        } else {
            PsiBuilder.Marker endOfBlock = this.mark();
            while (this.isJunk()) {
                if (this.getTokenType() == INDENT && this.getCurrentTokenLength() >= indent) {
                    this.dropEolMarker();
                    endOfBlock.drop();
                    this.advanceLexer();
                    endOfBlock = this.mark();
                    continue;
                }
                this.advanceLexer();
                this.dropEolMarker();
            }
            endOfBlock.rollbackTo();
        }
    }

    private int getIndentBonus(boolean insideSequence) {
        if (!insideSequence && this.getTokenType() == SEQUENCE_MARKER) {
            return 1;
        }
        return 0;
    }

    private int getShorthandIndentAddition() {
        int offset = this.myBuilder.getCurrentOffset();
        IElementType nextToken = this.myBuilder.lookAhead(1);
        if (nextToken != SEQUENCE_MARKER && nextToken != SCALAR_KEY) {
            return 1;
        }
        if (this.myBuilder.rawLookup(1) == WHITESPACE) {
            return this.myBuilder.rawTokenTypeStart(2) - offset;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private IElementType parseSingleStatement(int indent, int minIndent) {
        IElementType nodeType;
        if (this.eof()) {
            return null;
        }
        PsiBuilder.Marker marker = this.mark();
        this.parseNodeProperties();
        IElementType tokenType = this.getTokenType();
        if (tokenType == LBRACE) {
            nodeType = this.parseHash();
        } else if (tokenType == LBRACKET) {
            nodeType = this.parseArray();
        } else if (tokenType == SEQUENCE_MARKER) {
            nodeType = this.parseSequenceItem(indent);
        } else if (tokenType == QUESTION) {
            nodeType = this.parseExplicitKeyValue(indent);
        } else if (tokenType == SCALAR_KEY) {
            nodeType = this.parseScalarKeyValue(indent);
        } else if (YAMLElementTypes.SCALAR_VALUES.contains(this.getTokenType())) {
            nodeType = this.parseScalarValue(minIndent);
        } else if (tokenType == STAR) {
            PsiBuilder.Marker aliasMarker = this.mark();
            this.advanceLexer();
            if (this.getTokenType() == YAMLTokenTypes.ALIAS) {
                this.advanceLexer();
                aliasMarker.done((IElementType)YAMLElementTypes.ALIAS_NODE);
                if (this.getTokenType() != COLON) {
                    marker.drop();
                    return YAMLElementTypes.ALIAS_NODE;
                }
                this.eolSeen = false;
                int indentAddition = this.getShorthandIndentAddition();
                nodeType = this.parseSimpleScalarKeyValueFromColon(indent, indentAddition);
            } else {
                aliasMarker.drop();
                nodeType = null;
            }
        } else {
            this.advanceLexer();
            nodeType = null;
        }
        if (nodeType != null) {
            marker.done(nodeType);
            return nodeType;
        }
        marker.drop();
        return nodeType;
    }

    private void parseNodeProperties() {
        boolean anchorWasRead = false;
        boolean tagWasRead = false;
        while (this.getTokenType() == YAMLTokenTypes.TAG || this.getTokenType() == YAMLTokenTypes.AMPERSAND) {
            PsiBuilder.Marker errorMarker;
            if (this.getTokenType() == YAMLTokenTypes.AMPERSAND) {
                errorMarker = null;
                if (anchorWasRead) {
                    errorMarker = this.mark();
                }
                anchorWasRead = true;
                PsiBuilder.Marker anchorMarker = this.mark();
                this.advanceLexer();
                if (this.getTokenType() == YAMLTokenTypes.ANCHOR) {
                    this.advanceLexer();
                    anchorMarker.done((IElementType)YAMLElementTypes.ANCHOR_NODE);
                } else {
                    anchorMarker.drop();
                }
                if (errorMarker == null) continue;
                errorMarker.error(YAMLBundle.message("YAMLParser.multiple.anchors", new Object[0]));
                continue;
            }
            if (tagWasRead) {
                errorMarker = this.mark();
                this.advanceLexer();
                errorMarker.error(YAMLBundle.message("YAMLParser.multiple.tags", new Object[0]));
                continue;
            }
            tagWasRead = true;
            this.advanceLexer();
        }
    }

    @Nullable
    private IElementType parseScalarValue(int indent) {
        IElementType tokenType = this.getTokenType();
        assert (YAMLElementTypes.SCALAR_VALUES.contains(tokenType)) : "Scalar value expected!";
        if (tokenType == SCALAR_LIST || tokenType == SCALAR_TEXT) {
            return this.parseMultiLineScalar(tokenType);
        }
        if (tokenType == TEXT) {
            return this.parseMultiLinePlainScalar(indent);
        }
        if (tokenType == SCALAR_DSTRING || tokenType == SCALAR_STRING) {
            return this.parseQuotedString();
        }
        this.advanceLexer();
        return null;
    }

    @NotNull
    private IElementType parseQuotedString() {
        this.advanceLexer();
        YAMLElementType yAMLElementType = YAMLElementTypes.SCALAR_QUOTED_STRING;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(3);
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseMultiLineScalar(IElementType tokenType) {
        assert (tokenType == this.getTokenType());
        this.advanceLexer();
        if (this.getTokenType() == TEXT) {
            PsiBuilder.Marker err = this.myBuilder.mark();
            this.advanceLexer();
            err.error(YAMLBundle.message("YAMLParser.invalid.header.symbols", new Object[0]));
        }
        if (YAMLElementTypes.EOL_ELEMENTS.contains(this.getTokenType())) {
            this.advanceLexer();
        }
        PsiBuilder.Marker endOfValue = this.myBuilder.mark();
        IElementType type = this.getTokenType();
        while (type == tokenType || type == INDENT || type == SCALAR_EOL) {
            this.advanceLexer();
            if (type == tokenType) {
                if (endOfValue != null) {
                    endOfValue.drop();
                }
                endOfValue = null;
            }
            if (type == SCALAR_EOL) {
                if (endOfValue != null) {
                    endOfValue.drop();
                }
                endOfValue = this.myBuilder.mark();
            }
            type = this.getTokenType();
        }
        if (endOfValue != null) {
            endOfValue.rollbackTo();
        }
        YAMLElementType yAMLElementType = tokenType == SCALAR_LIST ? YAMLElementTypes.SCALAR_LIST_VALUE : YAMLElementTypes.SCALAR_TEXT_VALUE;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(4);
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseMultiLinePlainScalar(int indent) {
        PsiBuilder.Marker lastTextEnd = null;
        IElementType type = this.getTokenType();
        while (type == TEXT || type == INDENT || type == EOL) {
            this.advanceLexer();
            if (type == TEXT) {
                if (lastTextEnd != null && this.myIndent < indent) break;
                if (lastTextEnd != null) {
                    lastTextEnd.drop();
                }
                lastTextEnd = this.mark();
            }
            type = this.getTokenType();
        }
        this.rollBackToEol();
        assert (lastTextEnd != null);
        lastTextEnd.rollbackTo();
        YAMLElementType yAMLElementType = YAMLElementTypes.SCALAR_PLAIN_VALUE;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(5);
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseExplicitKeyValue(int indent) {
        assert (this.getTokenType() == QUESTION);
        int indentAddition = this.getShorthandIndentAddition();
        this.advanceLexer();
        if (!this.myStopTokensStack.isEmpty() && this.myStopTokensStack.peek() == HASH_STOP_TOKENS && this.getTokenType() == SCALAR_KEY) {
            this.parseScalarKeyValue(indent);
        } else {
            this.myStopTokensStack.add((Object)TokenSet.create((IElementType[])new IElementType[]{COLON}));
            this.eolSeen = false;
            this.parseBlockNode(indent + indentAddition, false);
            this.myStopTokensStack.pop();
            this.passJunk();
            if (this.getTokenType() == COLON) {
                indentAddition = this.getShorthandIndentAddition();
                this.advanceLexer();
                this.eolSeen = false;
                this.parseBlockNode(indent + indentAddition, false);
            }
        }
        YAMLElementType yAMLElementType = YAMLElementTypes.KEY_VALUE_PAIR;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(6);
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseScalarKeyValue(int indent) {
        assert (this.getTokenType() == SCALAR_KEY) : "Expected scalar key";
        this.eolSeen = false;
        int indentAddition = this.getShorthandIndentAddition();
        this.advanceLexer();
        return this.parseSimpleScalarKeyValueFromColon(indent, indentAddition);
    }

    @NotNull
    private IElementType parseSimpleScalarKeyValueFromColon(int indent, int indentAddition) {
        assert (this.getTokenType() == COLON) : "Expected colon";
        this.advanceLexer();
        PsiBuilder.Marker rollbackMarker = this.mark();
        this.passJunk();
        if (this.eolSeen && (this.eof() || this.myIndent + this.getIndentBonus(false) < indent + indentAddition)) {
            this.dropEolMarker();
            rollbackMarker.rollbackTo();
        } else {
            this.dropEolMarker();
            rollbackMarker.rollbackTo();
            this.parseBlockNode(indent + indentAddition, false);
        }
        YAMLElementType yAMLElementType = YAMLElementTypes.KEY_VALUE_PAIR;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(7);
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseSequenceItem(int indent) {
        assert (this.getTokenType() == SEQUENCE_MARKER);
        int indentAddition = this.getShorthandIndentAddition();
        this.advanceLexer();
        this.eolSeen = false;
        this.parseBlockNode(indent + indentAddition, true);
        this.rollBackToEol();
        YAMLElementType yAMLElementType = YAMLElementTypes.SEQUENCE_ITEM;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(8);
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseHash() {
        assert (this.getTokenType() == LBRACE);
        this.advanceLexer();
        this.myStopTokensStack.add((Object)HASH_STOP_TOKENS);
        while (!this.eof()) {
            if (this.getTokenType() == RBRACE) {
                this.advanceLexer();
                break;
            }
            this.parseSingleStatement(0, 0);
        }
        this.myStopTokensStack.pop();
        this.dropEolMarker();
        YAMLElementType yAMLElementType = YAMLElementTypes.HASH;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(9);
        }
        return yAMLElementType;
    }

    @NotNull
    private IElementType parseArray() {
        assert (this.getTokenType() == LBRACKET);
        this.advanceLexer();
        this.myStopTokensStack.add((Object)ARRAY_STOP_TOKENS);
        while (!this.eof()) {
            if (this.getTokenType() == RBRACKET) {
                this.advanceLexer();
                break;
            }
            if (this.isJunk()) {
                this.advanceLexer();
                continue;
            }
            PsiBuilder.Marker marker = this.mark();
            IElementType parsedElement = this.parseSingleStatement(0, 0);
            if (parsedElement != null) {
                marker.done((IElementType)YAMLElementTypes.SEQUENCE_ITEM);
            } else {
                marker.error(YAMLBundle.message("parsing.error.sequence.item.expected", new Object[0]));
            }
            if (this.getTokenType() != YAMLTokenTypes.COMMA) continue;
            this.advanceLexer();
        }
        this.myStopTokensStack.pop();
        this.dropEolMarker();
        YAMLElementType yAMLElementType = YAMLElementTypes.ARRAY;
        if (yAMLElementType == null) {
            YAMLParser.$$$reportNull$$$0(10);
        }
        return yAMLElementType;
    }

    private boolean eof() {
        return this.myBuilder.eof() || this.myBuilder.getTokenType() == DOCUMENT_MARKER;
    }

    @Nullable
    private IElementType getTokenType() {
        return this.eof() ? null : this.myBuilder.getTokenType();
    }

    private void dropEolMarker() {
        if (this.myAfterLastEolMarker != null) {
            this.myAfterLastEolMarker.drop();
            this.myAfterLastEolMarker = null;
        }
    }

    private void rollBackToEol() {
        if (this.eolSeen && this.myAfterLastEolMarker != null) {
            this.eolSeen = false;
            this.myAfterLastEolMarker.rollbackTo();
            this.myAfterLastEolMarker = null;
        }
    }

    private PsiBuilder.Marker mark() {
        this.dropEolMarker();
        return this.myBuilder.mark();
    }

    private void advanceLexer() {
        if (this.myBuilder.eof()) {
            return;
        }
        IElementType type = this.myBuilder.getTokenType();
        boolean eolElement = YAMLElementTypes.EOL_ELEMENTS.contains(type);
        boolean bl = this.eolSeen = this.eolSeen || eolElement;
        if (eolElement) {
            this.myAfterLastEolMarker = this.mark();
            this.myIndent = 0;
        } else if (type == INDENT) {
            this.myIndent = this.getCurrentTokenLength();
        } else {
            this.dropEolMarker();
        }
        this.myBuilder.advanceLexer();
    }

    private int getCurrentTokenLength() {
        return this.myBuilder.rawTokenTypeStart(1) - this.myBuilder.getCurrentOffset();
    }

    private void passJunk() {
        while (!this.eof() && this.isJunk()) {
            this.advanceLexer();
        }
    }

    private boolean isJunk() {
        IElementType type = this.getTokenType();
        return type == INDENT || type == EOL;
    }

    private static int findLeftRange(@NotNull List<IElementType> tokens) {
        int i;
        if (tokens == null) {
            YAMLParser.$$$reportNull$$$0(11);
        }
        return (i = tokens.indexOf((Object)COMMENT)) != -1 ? i : tokens.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/parser/YAMLParser";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/parser/YAMLParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseQuotedString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMultiLineScalar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMultiLinePlainScalar";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseExplicitKeyValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSimpleScalarKeyValueFromColon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSequenceItem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLeftRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

