/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class TracingData {
    private static final String tracingDataLocation = "E:\\ultimate\\system\\occurrences";
    private final PersistentHashMap<Integer, Integer> keys;
    private final ScheduledThreadPoolExecutor pool = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"My flushing thread");
    private final AtomicInteger maxHash = new AtomicInteger();
    private final AtomicInteger maxValue = new AtomicInteger();
    private ScheduledFuture<?> flushingFuture;

    TracingData() {
        PersistentHashMap<Integer, Integer> lkeys = null;
        try {
            lkeys = TracingData.createOrOpenMap();
            this.flushingFuture = this.pool.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (TracingData.this.keys.isDirty() && !TracingData.this.keys.isClosed()) {
                        TracingData.this.keys.force();
                    }
                }
            }, 5L, 5L, TimeUnit.SECONDS);
            ShutDownTracker.getInstance().registerShutdownTask(() -> this.flushingFuture.cancel(false));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.keys = lkeys;
    }

    private static PersistentHashMap<Integer, Integer> createOrOpenMap() throws IOException {
        return new PersistentHashMap(Paths.get(tracingDataLocation, new String[0]), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE);
    }

    public void record(int hash, int cost, PsiFragment frag) {
        if (this.keys != null) {
            try {
                Integer integer = (Integer)this.keys.get((Object)hash);
                int value = integer != null ? integer + 1 : 1;
                this.keys.put((Object)hash, (Object)value);
                int currentMaxValue = this.maxValue.get();
                while (value > currentMaxValue) {
                    if (this.maxValue.compareAndSet(currentMaxValue, value)) {
                        this.maxHash.set(hash);
                        System.out.println(this.maxValue + "," + this.maxHash + "," + frag.getElements()[0].getText());
                        break;
                    }
                    currentMaxValue = this.maxValue.get();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws IOException {
        PersistentHashMap<Integer, Integer> lKeys = TracingData.createOrOpenMap();
        IntArrayList mapping = new IntArrayList();
        lKeys.processKeysWithExistingMapping((Processor)new CommonProcessors.CollectProcessor((Collection)mapping));
        System.out.println(mapping.size());
        Int2IntOpenHashMap map = new Int2IntOpenHashMap(mapping.size());
        IntListIterator iterator = mapping.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            map.put(i, ((Integer)lKeys.get((Object)i)).intValue());
        }
        mapping.sort((arg_0, arg_1) -> TracingData.lambda$main$1((Int2IntMap)map, arg_0, arg_1));
        for (int i = 0; i < 500; ++i) {
            System.out.println(mapping.getInt(i) + ":" + map.get(mapping.getInt(i)));
        }
        lKeys.close();
    }

    private static /* synthetic */ int lambda$main$1(Int2IntMap map, int o1, int o2) {
        return map.get(o2) - map.get(o1);
    }
}

