/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.compiler;

import com.intellij.openapi.util.Ref;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.tools.ant.util.ReaderInputStream;
import org.jetbrains.jps.gradle.GradleJpsBundle;
import org.jetbrains.jps.gradle.compiler.ChainingFilterTransformer;
import org.jetbrains.jps.gradle.model.impl.GradleModuleResourceConfiguration;
import org.jetbrains.jps.gradle.model.impl.GradleProjectConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.gradle.model.impl.ResourceRootFilter;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsProject;

public class GradleResourceFileProcessor {
    private static final int FILTERING_SIZE_LIMIT = 0xA00000;
    protected final JpsEncodingProjectConfiguration myEncodingConfig;
    protected final GradleProjectConfiguration myProjectConfig;
    protected final GradleModuleResourceConfiguration myModuleConfiguration;

    public GradleResourceFileProcessor(GradleProjectConfiguration projectConfiguration, JpsProject project, GradleModuleResourceConfiguration moduleConfiguration) {
        this.myProjectConfig = projectConfiguration;
        this.myEncodingConfig = JpsEncodingConfigurationService.getInstance().getEncodingConfiguration(project);
        this.myModuleConfiguration = moduleConfiguration;
    }

    public void copyFile(File file, Ref<File> targetFileRef, ResourceRootConfiguration rootConfiguration, CompileContext context, FileFilter filteringFilter) throws IOException {
        boolean shouldFilter;
        boolean bl = shouldFilter = rootConfiguration.isFiltered && !rootConfiguration.filters.isEmpty() && filteringFilter.accept(file);
        if (shouldFilter && file.length() > 0xA00000L) {
            context.processMessage((BuildMessage)new CompilerMessage(GradleJpsBundle.message("gradle.resources.compiler", new Object[0]), BuildMessage.Kind.WARNING, GradleJpsBundle.message("file.is.too.big.to.be.filtered", new Object[0]), file.getPath()));
            shouldFilter = false;
        }
        if (shouldFilter) {
            GradleResourceFileProcessor.copyWithFiltering(file, targetFileRef, rootConfiguration.filters, context);
        } else {
            FSOperations.copy((File)file, (File)((File)targetFileRef.get()));
        }
    }

    private static void copyWithFiltering(File file, Ref<File> outputFileRef, List<ResourceRootFilter> filters, CompileContext context) throws IOException {
        try (InputStream inputStream = GradleResourceFileProcessor.transform(file, filters, outputFileRef, context);){
            Path target = ((File)outputFileRef.get()).toPath();
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(inputStream, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static InputStream transform(File file, List<ResourceRootFilter> filters, Ref<File> outputFileRef, CompileContext context) throws FileNotFoundException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        Reader transformer = new ChainingFilterTransformer(context, filters, outputFileRef).transform(reader);
        return new ReaderInputStream(transformer);
    }
}

