/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.build;

import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.ant.execution.AntMain2;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ant.AntJpsBundle;
import org.jetbrains.jps.ant.build.AntBuildTaskListener;
import org.jetbrains.jps.ant.model.JpsAntBuildFileOptions;
import org.jetbrains.jps.ant.model.JpsAntExtensionService;
import org.jetbrains.jps.ant.model.JpsAntInstallation;
import org.jetbrains.jps.ant.model.artifacts.JpsAntArtifactExtension;
import org.jetbrains.jps.ant.model.impl.JpsAntInstallationImpl;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ExternalProcessUtil;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.jps.util.JpsPathUtil;

public class AntArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    private static final Logger LOG = Logger.getInstance(AntArtifactBuildTaskProvider.class);

    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        JpsAntArtifactExtension extension;
        if (artifact == null) {
            AntArtifactBuildTaskProvider.$$$reportNull$$$0(0);
        }
        if (buildPhase == null) {
            AntArtifactBuildTaskProvider.$$$reportNull$$$0(1);
        }
        if ((extension = AntArtifactBuildTaskProvider.getBuildExtension(artifact, buildPhase)) != null && extension.isEnabled() && !StringUtil.isEmpty((String)extension.getFileUrl())) {
            List<AntArtifactBuildTask> list = Collections.singletonList(new AntArtifactBuildTask(extension));
            if (list == null) {
                AntArtifactBuildTaskProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            AntArtifactBuildTaskProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static JpsAntArtifactExtension getBuildExtension(JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        switch (buildPhase) {
            case PRE_PROCESSING: {
                return JpsAntExtensionService.getPreprocessingExtension(artifact);
            }
            case POST_PROCESSING: {
                return JpsAntExtensionService.getPostprocessingExtension(artifact);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPhase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactBuildTasks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AntArtifactBuildTask
    extends BuildTask {
        @NlsSafe
        public static final String BUILDER_NAME = "ant";
        private final JpsAntArtifactExtension myExtension;

        AntArtifactBuildTask(@NotNull JpsAntArtifactExtension extension) {
            if (extension == null) {
                AntArtifactBuildTask.$$$reportNull$$$0(0);
            }
            this.myExtension = extension;
        }

        public void build(final CompileContext context) throws ProjectBuildException {
            JpsTypedLibrary jdkLibrary;
            JpsProject project = context.getProjectDescriptor().getProject();
            JpsAntBuildFileOptions options = JpsAntExtensionService.getOptions(project, this.myExtension.getFileUrl());
            String jdkName = options.getCustomJdkName();
            if (!StringUtil.isEmpty((String)jdkName)) {
                jdkLibrary = project.getModel().getGlobal().getLibraryCollection().findLibrary(jdkName, (JpsLibraryType)JpsJavaSdkType.INSTANCE);
                if (jdkLibrary == null) {
                    this.reportError(context, "JDK '" + jdkName + "' not found");
                    throw new StopBuildException();
                }
            } else {
                JpsSdkReference reference = project.getSdkReferencesTable().getSdkReference((JpsSdkType)JpsJavaSdkType.INSTANCE);
                if (reference == null) {
                    this.reportError(context, "project JDK is not specified");
                    throw new StopBuildException();
                }
                jdkLibrary = (JpsTypedLibrary)reference.resolve();
                if (jdkLibrary == null) {
                    this.reportError(context, "JDK '" + reference.getSdkName() + "' not found");
                    throw new StopBuildException();
                }
            }
            JpsSdk jdk = (JpsSdk)jdkLibrary.getProperties();
            JpsAntInstallation antInstallation = JpsAntExtensionService.getAntInstallationForBuildFile(context.getProjectDescriptor().getModel(), this.myExtension.getFileUrl());
            if (antInstallation == null) {
                this.reportError(context, "Ant installation is not configured");
                throw new StopBuildException();
            }
            ArrayList<String> classpath = new ArrayList<String>();
            File jreHome = new File(jdk.getHomePath(), "jre");
            for (File file : jdkLibrary.getFiles(JpsOrderRootType.COMPILED)) {
                if (FileUtil.isAncestor((File)jreHome, (File)file, (boolean)false)) continue;
                classpath.add(file.getAbsolutePath());
            }
            classpath.addAll(options.getAdditionalClasspath());
            classpath.addAll(antInstallation.getClasspath());
            JpsAntInstallationImpl.addAllJarsFromDirectory(classpath, new File(SystemProperties.getUserHome(), ".ant/lib"));
            classpath.add(PathManager.getJarPathForClass(AntMain2.class));
            ArrayList<String> vmParams = new ArrayList<String>();
            vmParams.add("-Xmx" + options.getMaxHeapSize() + "m");
            vmParams.add("-Xss" + options.getMaxStackSize() + "m");
            vmParams.add("-Dant.home=" + antInstallation.getAntHome().getAbsolutePath());
            ArrayList<String> programParams = new ArrayList<String>();
            for (String param : ParametersListUtil.parse((String)options.getAntCommandLineParameters())) {
                if (param.startsWith("-J")) {
                    String vmParam = StringUtil.trimStart((String)param, (String)"-J");
                    if (vmParam.isEmpty()) continue;
                    vmParams.add(vmParam);
                    continue;
                }
                programParams.add(param);
            }
            for (List properties : Arrays.asList(this.myExtension.getAntProperties(), options.getProperties())) {
                for (BuildFileProperty property : properties) {
                    programParams.add("-D" + property.getPropertyName() + "=" + property.getPropertyValue());
                }
            }
            programParams.add("-buildfile");
            final String buildFilePath = JpsPathUtil.urlToPath((String)this.myExtension.getFileUrl());
            programParams.add(buildFilePath);
            final String targetName = this.myExtension.getTargetName();
            if (targetName != null) {
                programParams.add(targetName);
            }
            @NlsSafe String buildFileName = PathUtilRt.getFileName((String)buildFilePath);
            String targetDisplayName = targetName != null ? targetName : AntJpsBundle.message("ant.target.default.name", new Object[0]);
            context.processMessage((BuildMessage)new ProgressMessage(AntJpsBundle.message("running.ant.target.from.file", targetDisplayName, buildFileName)));
            Iterable listeners = JpsServiceManager.getInstance().getExtensions(AntBuildTaskListener.class);
            for (AntBuildTaskListener listener : listeners) {
                listener.beforeAntBuildTaskStarted(this.myExtension, vmParams, programParams);
            }
            List commandLine = ExternalProcessUtil.buildJavaCommandLine((String)JpsJavaSdkType.getJavaExecutable((JpsSdk)jdk), (String)AntMain2.class.getName(), Collections.emptyList(), classpath, vmParams, programParams, (boolean)false);
            try {
                Process process = new ProcessBuilder(commandLine).directory(new File(buildFilePath).getParentFile()).start();
                String commandLineString = StringUtil.join((Collection)commandLine, (String)" ");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting ant target:" + commandLineString);
                }
                BaseOSProcessHandler handler = new BaseOSProcessHandler(process, commandLineString, null);
                final AtomicBoolean hasErrors = new AtomicBoolean();
                final @NlsSafe StringBuilder errorOutput = new StringBuilder();
                handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (outputType == ProcessOutputTypes.STDERR) {
                            errorOutput.append(event.getText());
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        int exitCode;
                        if (event == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if ((exitCode = event.getExitCode()) != 0) {
                            context.processMessage((BuildMessage)new CompilerMessage(AntArtifactBuildTask.BUILDER_NAME, BuildMessage.Kind.ERROR, errorOutput.toString()));
                            String message = AntJpsBundle.message("target.finished.with.exit.code", targetName, buildFilePath, exitCode);
                            context.processMessage((BuildMessage)new CompilerMessage(AntArtifactBuildTask.BUILDER_NAME, BuildMessage.Kind.ERROR, message));
                            hasErrors.set(true);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "outputType";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider$AntArtifactBuildTask$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onTextAvailable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processTerminated";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                handler.startNotify();
                handler.waitFor();
                if (hasErrors.get()) {
                    throw new StopBuildException();
                }
            }
            catch (IOException e) {
                throw new ProjectBuildException((Throwable)e);
            }
        }

        private void reportError(CompileContext context, @NlsSafe String text) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, AntJpsBundle.message("cannot.run.target", this.myExtension.getTargetName(), text)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/ant/build/AntArtifactBuildTaskProvider$AntArtifactBuildTask", "<init>"));
        }
    }
}

